import { DOCUMENT, ViewportScroller } from "@angular/common";
import { AfterViewInit, Component, inject } from "@angular/core";
import { Observable, fromEvent, map } from "rxjs";

@Component({
  selector: 'component-details-with-header',
  template: `
    <head>
      <meta charset="utf-8" />
      <!-- other meta tags -->
      <script src="https://website-widgets.pages.dev/dist/sienna.min.js"></script>
      <style>
      .spacer {
        height: 7vh;
      }

      @media screen and (min-width: 1800px) {
        .spacer {
          height: 4vh;
        }
      }
      @media screen and (min-width: 2100px) {
        .spacer {
          height: 1vh;
        }
      }
      </style>
    </head>
    <body>
      <div class="page-container">

        <app-sticky-menu></app-sticky-menu>
        <app-navigation-bar></app-navigation-bar>
        <div style="margin-top: 65px"></div>
    
        <app-page-header
          [breadcrumbs]="breadcrumbs" [ngStyle]="{'margin-bottom': '0'}"
        ></app-page-header>
        <div style="flex-grow:1">
         <training-details></training-details>
        </div>
        <div style="margin-top: 5%"></div>
        <app-footer-section
          style="position: relative;bottom: 0;left: 0;right: 0;"
        ></app-footer-section>
        <app-scroll-top
          *ngIf="showScroll$ | async"
          (scrollToTop)="onScrollToTop()"
        ></app-scroll-top>
      </div>
    </body>
  `,
  styleUrls: [],
})
export class TrainingDetailsWithHeader implements AfterViewInit {

  ngAfterViewInit(): void {
    const script = document.createElement('script');
    script.src = 'https://website-widgets.pages.dev/dist/sienna.min.js';
    script.async = true;  // or false, depending on your needs

    script.onload = () => {
      console.log('Sienna script loaded!');
      // Optionally, call any global functions provided by the script
      // For example: window['Sienna']?.init(...);
    };

    // Append the script element to the document head (or body)
    document.head.appendChild(script);
  }

  breadcrumbs = [
    { label: 'Learning Centre', url: '/learning-centre' },
    { label: 'Course Details', url: '/' },
  ];

  private readonly document = inject(DOCUMENT);
  private readonly viewport = inject(ViewportScroller);
  readonly showScroll$: Observable<boolean> = fromEvent(
    this.document,
    'scroll'
  ).pipe(
    map(() => this.viewport.getScrollPosition()?.[1] > 0)
  );

  onScrollToTop(): void {
    this.viewport.scrollToPosition([0, 0]);
  }
}