import { Component, inject } from '@angular/core';
import { CommonModule } from '@angular/common';
import { IframeComponent, IframeProps } from '../iframe/iframe.component';
import { ActivatedRoute } from '@angular/router';
import { MatProgressSpinnerModule } from '@angular/material/progress-spinner';
import { SnackbarService } from 'src/app/services/snackbar/snackbar.service';
import { OpenAPIService } from 'src/app/services/open-api.service';

@Component({
  selector: 'training-details',
  standalone: true,
  imports: [CommonModule, IframeComponent, MatProgressSpinnerModule],
  template: `
    <div *ngIf="loading" class="loading-container">
      <mat-spinner></mat-spinner>
    </div>

    <div
      *ngIf="!loading && iframeProps"
      [ngStyle]="{ 'max-width': '1100px', margin: '0 auto' }"
    >
      <iframe-component
        [iframeProps]="iframeProps"
        (loaded)="onIframeLoad($event)"
      ></iframe-component>
    </div>
  `,
  styles: [
    `
      .loading-container {
        display: flex;
        justify-content: center;
        align-items: center;
        height: 100vh; /* Adjust as necessary */
      }

      .snackbar-success {
        background-color: #4caf50; /* Green */
        color: #fff;
      }

      .snackbar-error {
        background-color: #f44336; /* Red */
        color: #fff;
      }
    `,
  ],
})
export class TrainingDetails {
  iframeProps: IframeProps | undefined;
  route: ActivatedRoute = inject(ActivatedRoute);
  loading: boolean = true;
  private snackbarService: SnackbarService = inject(SnackbarService);

  constructor(private openAPIService: OpenAPIService) {
  }

  async ngOnInit() {
    // Obtains the url with the training resource details page
    const { status, value: url } = await this.openAPIService.generateTrainingResourceDetailsIframeURL(this.route.snapshot.params['id'])
    if (status === 200) this.iframeProps = { url };
    this.showSpinner();
  }

  showSpinner(): void {
    setTimeout(() => {
      this.loading = false;
    }, 5000);
  }

  onIframeLoad(success: boolean): void {
    if (success) {
      // this.snackbarService.success('Content loaded successfully!', 'Close', 3000);
    } else {
      this.snackbarService.error('Failed to load content. Please try again.', 'Close', 3000);
    }
  }
}