import { Component } from '@angular/core';
import { CommonModule } from '@angular/common';
@Component({
    selector: "training-list-banner",
    standalone: true,
    imports: [CommonModule],
    styles: [
        `
        .training-list-banner {
            background-color: #1c2c37;
            height: 120px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            border-radius:1rem;
            padding:0 1rem;
        }
        .training-list-banner-title {
            color: #ffc002;
            font-size: 28px;
            margin-top:0;
            margin-bottom:0.25rem;
            line-height: 1;
        
        }
        .training-list-banner-sub-title {
            color: #f2f2f2;
            font-size: 14px;
            margin-top: 0.25rem;
            margin-bottom:0;
            line-height: 1;
        }
        .training-list-banner-right-area {
            display: flex;
        }

        .training-list-banner-icon.video {
            width:27px;
        }
         .training-list-banner-icon.webinars {
            width:30px;
        }
        .training-list-banner-icon.workshops {
            width:30px;
        }     
        .training-list-banner-label {
            color: #f2f2f2;
        }
        .training-list-banner-icon-container {
            height: 50px;
            display: flex;
        }
        .training-list-banner-label {
            font-size: 23px;
            margin-bottom:0px;
        }
        .training-list-banner-icon-box.first {
            margin-left:1rem;
        }
        .training-list-banner-icon-box {
            display: flex;
            flex-direction: column;
            align-items: center;
            margin-left: 5rem;
        }
        .training-list-banner {
            background-size: contain;
            background-repeat: no-repeat;
        }
        @media(max-width : 1461px){
            .training-list-banner {
                background-size: cover;
                background-position: center;
            }
        }
        @media(max-width : 1200px){
            .training-list-banner-icon-box {
               margin-left:2rem;
            }
        }
        @media(max-width : 1095px){
            .training-list-banner{
                height:auto;
                flex-direction: column;
                padding-top:1rem;
                padding-bottom:1rem;
            }
            .training-list-banner-icon-box.first,
            .training-list-banner-icon-box {
                margin-left:0px;
            }
            .training-list-banner-sub-title {
                margin-bottom:1rem;
            }

            .training-list-banner-right-area {
                width: 350px;
                justify-content: space-between;
            }

            .training-list-banner-sub-title {
                text-align: center;
            }
        }
       `
    ],
    template: `
        <div class="training-list-banner" style="background-image: url('/assets/training-banner/bg.webp');">
            <div class="training-list-banner-left-area">
                <p class="training-list-banner-title">
                    Explore more types of content here
                </p>
                <p class="training-list-banner-sub-title">
                    Click on the banner to go to the website
                </p>
            </div>
            <div class="training-list-banner-right-area">
                <div class="training-list-banner-icon-box first">
                    <div class="training-list-banner-icon-container">
                        <img class="training-list-banner-icon video" src="/assets/training-banner/icons/play-btn.svg"/>
                    </div>
                    <p class="training-list-banner-label">Videos</p>
                </div>
                <div class="training-list-banner-icon-box">
                    <div class="training-list-banner-icon-container">
                        <img class="training-list-banner-icon webinars" src="/assets/training-banner/icons/webinar.svg"/>
                    </div>
                    <p class="training-list-banner-label">Webinars</p>
                </div>
                <div class="training-list-banner-icon-box">
                    <div class="training-list-banner-icon-container">
                        <img class="training-list-banner-icon workshops" src="/assets/training-banner/icons/workshops.svg"/>
                    </div>
                    <p class="training-list-banner-label">Workshops</p>
                </div>
            </div>
        </div>
    `
})
export class TrainingListBanner {

}