import { Component, computed, effect, signal, ViewChild } from '@angular/core';
import { CommonModule } from '@angular/common';
import { IframeComponent, IframeProps } from '../iframe/iframe.component';
import { Loading } from '../iframe/loading.component';
// import { IOT_CAT_URL } from 'src/app/services/iot-cat.service';
import { SnackbarService } from 'src/app/services/snackbar/snackbar.service';
import { environment } from 'src/environments/environment';
import { OpenAPIService } from 'src/app/services/open-api.service';
import { ElementList } from '../element-list/element-list.component';
import { TrainingListBanner } from '../training-list-banner/training-list-banner';
import { MatButtonModule } from '@angular/material/button';

@Component({
  selector: 'training-list',
  standalone: true,
  imports: [CommonModule, IframeComponent, Loading, TrainingListBanner, MatButtonModule],
  styles: [
    `
      .training-list {
        display: flex;
        flex-direction: column;
      }

      .training-list-spacing {
        flex-grow: 1;
      }
      .training-list-buttons {
        display: flex;
        justify-content: flex-end;
      }
      .training-list-buttons > * {
        margin-left: 1rem;
      }
      .training-banner-link {
        text-decoration: none;
      }
    `
  ],
  template: `
    <div *ngIf="this.iframeProps === null" style="width:100%">
      <loading-component ></loading-component>
    </div>
    <div class="training-list" style="margin-top:1rem;margin-left:2rem;margin-right:2rem;width:92%" *ngIf="this.iframeProps !== null">
      <div class="training-list-buttons">
         <button mat-raised-button [color]="this.getButtonColor('fame')" (click)="onButtonClick('fame')">{{getButtonLabel("FAME")}}</button>
         <button mat-raised-button [color]="this.getButtonColor('chameleon')" (click)="onButtonClick('chameleon')">{{getButtonLabel("Chameleon")}}</button>
      </div>
      <iframe-component #iframe class=" bg-black" [iframeProps]="this.iframeProps"></iframe-component>

      <div class="training-list-spacing"></div>
      <a href="https://www.fame-horizon.eu/learning-centre" class="training-banner-link" target="_blank">
        <training-list-banner/>
      </a>
    </div>

  `,
  styleUrls: [],
})
export class TrainingList extends ElementList {
  isLoading = true; // Spinner shown by default

  projectIds: { [name: string]: (string | undefined) } = {
    fame: "6687d3dc1351670b2fa46a32",
    chameleon: "65b8e9a6511dfe02b891a3e4"
  }

  selectedProjects = signal<string[]>(["fame"])
  @ViewChild("iframe")
  set setIframe(el: IframeComponent) {
    this.iframe = el
  };



  onButtonClick(projectName: string) {
    const selectedProjects = this.selectedProjects()
    if (!selectedProjects.includes(projectName)) {
      this.selectedProjects.set([...selectedProjects, projectName])
    } else if (selectedProjects.length > 1) {
      this.selectedProjects.set(selectedProjects.filter(e => e !== projectName))
    }
  }

  getButtonColor(projectName: string) {
    if (this.selectedProjects().includes(projectName)) return "primary"
    return "basic"
  }

  constructor(private snackbarService: SnackbarService) {
    super()
    effect(() => {
      console.log("computed", this.selectedProjects())
      this.setProjects(this.selectedProjects())
    })

  }

  setProjects(projectNames: string[] | undefined) {
    const projectIds = projectNames?.map(name => this.projectIds[name]).filter(e => e !== undefined) || []
    const selection = projectIds.map(elementId => ({
      categoryId: "_project",
      elementId
    }))
    this.iframe?.sendMessage({ action: "setCategoryFilter", value: { selection } })

  }

  getButtonLabel(projectName: string) {
    const prepend = this.selectedProjects().includes(projectName.toLowerCase()) ? "Hide" : "Show"
    return `${prepend} ${projectName}`
  }
  getSelectedProjectIds(): string[] {
    const ids: string[] = []
    for (const name of this.selectedProjects()) {
      if (this.projectIds[name] !== undefined) ids.push(this.projectIds[name] as string)
    }
    return ids
  }
  async ngOnInit() {

    setTimeout(() => {
      return
      this.selectedProjects.set(["chameleon"])
    }, 15000)
    // Obtains the url with the training list added to the context of fame
    const { value: url, status } = await this.openAPIService.generateTrainingResourceListIframeURL(this.getSelectedProjectIds());
    if (status === 200) this.iframeProps = { url };
  }
}