
import { Component, CUSTOM_ELEMENTS_SCHEMA, ElementRef, inject } from '@angular/core';
import { CommonModule } from '@angular/common';
import { IframeComponent, IframeProps } from '../iframe/iframe.component';
import { ActivatedRoute } from '@angular/router';
import { OpenAPIService } from 'src/app/services/open-api.service';

@Component({
    selector: 'validation-details',
    standalone: true,
    imports: [CommonModule, IframeComponent],
    template: `
    <div *ngIf="iframeProps!==undefined" [ngStyle]="{'max-width':'1100px','margin':'0 auto'} " >
        <iframe-component [iframeProps]="this.iframeProps"></iframe-component>
    </div>
    `,
    styleUrls: [],
})
export class ValidationDetails {
    iframeProps: IframeProps | undefined
    route: ActivatedRoute = inject(ActivatedRoute);

    constructor(private openAPIService: OpenAPIService) {
    }
    async ngOnInit() {
        const { status, value } = await this.openAPIService.generateValidationDetailsIframeURL(this.route.snapshot.params['id'])
        if (status !== 200) return
        this.iframeProps = {
            url: value
        }
    }
}