import { Component, HostListener, OnInit } from '@angular/core';
import { MatDialog } from '@angular/material/dialog';
import { DialogOfferingLogComponent, OfferingLogEntry } from 'src/app/components/dialog-offering-log/dialog-offering-log.component';
import { DialogPublishingLogComponent, LogEntry } from 'src/app/components/dialog-publishing-log/dialog-publishing-log.component';
import { DialogTradingLogComponent, TradingLogEntry } from 'src/app/components/dialog-trading-log/dialog-trading-log.component';
import { DialogTrendingLogComponent, TrendingLogEntry } from 'src/app/components/dialog-trending-log/dialog-trending-log.component';
import { single } from './data';
import {Color, ScaleType} from '@swimlane/ngx-charts';

@Component({
  selector: 'app-admin-dashboard',
  templateUrl: './admin-dashboard.component.html',
  styleUrls: ['./admin-dashboard.component.scss']
})
export class AdminDashboardComponent implements OnInit {

  // @ts-ignore
  single: any[];
  // @ts-ignore
  multi: any[];

  view: [number, number] = [1020, 400];

  // options
  showXAxis = true;
  showYAxis = true;
  gradient = false;
  showLegend = true;
  showXAxisLabel = true;
  xAxisLabel = 'Country';
  showYAxisLabel = true;
  yAxisLabel = 'Value';

  // @ts-ignore
  colorScheme: Color = {
    name: 'myScheme',
    selectable: true,
    group: ScaleType.Ordinal, // or ScaleType.Linear
    domain: ['#5AA454', '#A10A28', '#C7B42C', '#AAAAAA', '#3333CC', '#FF6600', '#990099']
  };

  selectedIndicator: string = 'turnover';
  selectedTimePeriod: string = 'daily';

  constructor(private dialog: MatDialog) {
    Object.assign(this, { single })
  }

  // @ts-ignore
  onSelect(event) {
    console.log(event);
  }

  ngOnInit() {
    this.updateChartView(window.innerWidth);
  }

  // HostListener to track window size changes
  @HostListener('window:resize', ['$event'])
  onResize(event: any) {
    const width = event.target.innerWidth;
    this.updateChartView(width);
  }

  /**
   * Adjust the chart's `view` property based on screen width.
   */
  updateChartView(width: number) {
    if (width < 768) {
      // Mobile
      this.view = [360, 300];
    } else if (width < 1024) {
      // Tablet / medium
      this.view = [600, 400];
    } else {
      // Desktop
      this.view = [1020, 400];
    }
  }

  openPublishingLog(): void {
    const dialogRef = this.dialog.open(DialogPublishingLogComponent, {
      width: '80%',
      data: this.getLogData() // Replace with your method to get log data
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
    });
  }

  openOfferingLog(): void {
    const dialogRef = this.dialog.open(DialogOfferingLogComponent, {
      width: '80%',
      data: this.getOfferingLogData() // Replace with your method to get offering log data
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
    });
  }

  openTrendingLog(): void {
    const dialogRef = this.dialog.open(DialogTrendingLogComponent, {
      width: '80%',
      data: this.getTrendingLogData() // Replace with your method to get trending log data
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
    });
  }

  openTradingLog(): void {
    const dialogRef = this.dialog.open(DialogTradingLogComponent, {
      width: '80%',
      data: this.getTradingLogData() // Replace with your method to get trading log data
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
    });
  }

  getLogData(): LogEntry[] {
    // Replace this with your actual data fetching logic
    return [
      { aid: '4ad0d354-93a4-4e4e-bebe-57c428cd5f36', type: 'DATASET', pid: '1047bb5e-5ad5-4d9e-be94-183dc37d92e9', ts: '24/02/2024 15:30:00' },
      { aid: '4ad0d354-93a4-4e4e-bebe-57c428cd5f36', type: 'SOFTWARE', pid: '1047bb5e-5ad5-4d9e-be94-183dc37d92e9', ts: '24/02/2024 15:30:00' },
      { aid: '4ad0d354-93a4-4e4e-bebe-57c428cd5f36', type: 'TUTORIAL', pid: '1047bb5e-5ad5-4d9e-be94-183dc37d92e9', ts: '24/02/2024 15:30:00' },
      // Add more entries as needed
    ];
  }

  getOfferingLogData(): OfferingLogEntry[] {
    // Replace this with your actual data fetching logic
    return [
      { oid: 'e1c4be79-f8c2-4243-a4f6-b534dd8e5e89', type: 'SUBSCRIPTION', aid: '4ad0d354-93a4-4e4e-bebe-57c428cd5f36', ts: '24/02/2024 15:30:00' },
      { oid: 'e1c4be79-f8c2-4243-a4f6-b534dd8e5e89', type: 'SUBSCRIPTION', aid: '4ad0d354-93a4-4e4e-bebe-57c428cd5f36', ts: '24/02/2024 15:30:00' },
      { oid: 'e1c4be79-f8c2-4243-a4f6-b534dd8e5e89', type: 'SUBSCRIPTION', aid: '4ad0d354-93a4-4e4e-bebe-57c428cd5f36', ts: '24/02/2024 15:30:00' },
      // Add more entries as needed
    ];
  }

  getTrendingLogData(): TrendingLogEntry[] {
    // Replace this with your actual data fetching logic
    return [
      { oid: 'e1c4be79-f8c2-4243-a4f6-b534dd8e5e89', type: 'SUBSCRIPTION', aid: '4ad0d354-93a4-4e4e-bebe-57c428cd5f36', turnover: 5500.00 },
      { oid: 'e1c4be79-f8c2-4243-a4f6-b534dd8e5e89', type: 'SUBSCRIPTION', aid: '4ad0d354-93a4-4e4e-bebe-57c428cd5f36', turnover: 5500.00 },
      { oid: 'e1c4be79-f8c2-4243-a4f6-b534dd8e5e89', type: 'SUBSCRIPTION', aid: '4ad0d354-93a4-4e4e-bebe-57c428cd5f36', turnover: 5500.00 },
      // Add more entries as needed
    ];
  }

  getTradingLogData(): TradingLogEntry[] {
    // Replace this with your actual data fetching logic
    return [
      { txid: '0627052bf8298127303066a912ea57', amount: 500.00, oid: 'e1c4be79-f8c2-4243-a4f6-b534dd8e5e89', ts: new Date() },
      { txid: '0627052bf8298127303066a912ea57', amount: 500.00, oid: 'e1c4be79-f8c2-4243-a4f6-b534dd8e5e89', ts: new Date() },
      { txid: '0627052bf8298127303066a912ea57', amount: 500.00, oid: 'e1c4be79-f8c2-4243-a4f6-b534dd8e5e89', ts: new Date() },
      // Add more entries as needed
    ];
  }
}