import { AfterViewInit, Component, OnInit, ViewChild } from '@angular/core';
import { MatPaginator } from '@angular/material/paginator';
import { MatTableDataSource } from '@angular/material/table';

@Component({
  selector: 'app-administrator-list',
  templateUrl: './administrator-list.component.html',
  styleUrls: ['./administrator-list.component.scss']
})
export class AdministratorListComponent implements AfterViewInit {

  searchQuery: string = '';
  selectedSort: string = 'newest';
  hideInactive: boolean = false;
  displayedColumns: string[] = ['fullName', 'uid', 'affiliation', 'status'];
  dataSource = new MatTableDataSource<Administrator>(ADMIN_DATA);
  totalLength = ADMIN_DATA.length;

  // ngOnInit(): void {
  //   // Additional initialization logic if needed
  // }
  
  @ViewChild(MatPaginator) paginator!: MatPaginator;
  ngAfterViewInit() {
    this.dataSource.paginator = this.paginator;
  }

  applyFilter(): void {
    this.dataSource.filter = this.searchQuery.trim().toLowerCase();
  }

  sortData(): void {
    // Implement sorting logic based on selectedSort
  }

  filterData(): void {
    // Implement filtering logic based on hideInactive
  }

  onPageChange(event: any): void {
    // Implement pagination logic
  }

  getStatusClass(status: string): string {
    switch (status.toLowerCase()) {
      case 'invited': return 'invited';
      case 'onboarded': return 'onboarded';
      case 'offboarded': return 'offboarded';
      default: return '';
    }
  }

}

export interface Administrator {
  fullName: string;
  uid: string;
  affiliation: string;
  status: string;
}

const ADMIN_DATA: Administrator[] = [
  { fullName: 'John Doe', uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', affiliation: 'XYZ Company', status: 'INVITED' },
  { fullName: 'John Doe', uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', affiliation: 'XYZ Company', status: 'ONBOARDED' },
  { fullName: 'John Doe', uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', affiliation: 'XYZ Company', status: 'INVITED' },
  { fullName: 'John Doe', uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', affiliation: 'XYZ Company', status: 'ONBOARDED' },
  { fullName: 'John Doe', uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', affiliation: 'XYZ Company', status: 'OFFBOARDED' },
  { fullName: 'John Doe', uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', affiliation: 'XYZ Company', status: 'INVITED' },
  { fullName: 'John Doe', uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', affiliation: 'XYZ Company', status: 'ONBOARDED' },
  { fullName: 'John Doe', uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', affiliation: 'XYZ Company', status: 'OFFBOARDED' },
  { fullName: 'John Doe', uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', affiliation: 'XYZ Company', status: 'INVITED' },
  { fullName: 'John Doe', uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', affiliation: 'XYZ Company', status: 'ONBOARDED' },
  { fullName: 'John Doe', uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', affiliation: 'XYZ Company', status: 'INVITED' },
  { fullName: 'John Doe', uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', affiliation: 'XYZ Company', status: 'ONBOARDED' },
  { fullName: 'John Doe', uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', affiliation: 'XYZ Company', status: 'OFFBOARDED' },
  { fullName: 'John Doe', uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', affiliation: 'XYZ Company', status: 'INVITED' },
  { fullName: 'John Doe', uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', affiliation: 'XYZ Company', status: 'ONBOARDED' },
  { fullName: 'John Doe', uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', affiliation: 'XYZ Company', status: 'OFFBOARDED' },
];