import { Component, OnInit, ViewChild } from '@angular/core';
import { NgForm } from '@angular/forms';
import { Router } from '@angular/router';

@Component({
  selector: 'app-member-details',
  templateUrl: './member-details.component.html',
  styleUrls: ['./member-details.component.scss']
})
export class MemberDetailsComponent implements OnInit {

  @ViewChild('memberForm') memberForm!: NgForm;
  member = {
    name: 'Some Federation Authority',
    did: 'did:gktc:2itDAKCERh95uGgKbJNHYP',
    description: 'Desc',
    type: 'AUTHORITY',
    country: 'Italy',
    contactEmail: 'test@test.com',
    status: 'ONBOARDED',
    onboardedDate: '10/03/2024 10:23:55',
    offboardedDate: 'N/A'
  };

  types: string[] = ['AUTHORITY', 'DATASPACE'];
  countries: string[] = ['Italy', 'Greece', 'USA', 'Canada', 'UK', 'Germany'];

  onSubmit() {
    if (this.memberForm.valid) {
      console.log('Form Submitted', this.member);
    }
  }

  onDiscard() {
    // Implement discard logic if needed
    console.log('Form Discarded');
  }

  constructor( private router: Router) { }

  ngOnInit() {
  }

  get breadcrumbs(): { url: () => void; label: string }[] {
    return [
      { url: () => this.router.navigate(['/member-list']), label: 'List' },
      { url: () => this.router.navigate(['/member-details']), label: 'Details' },
    ];
  }
}