import { AfterViewInit, Component, OnInit, ViewChild } from '@angular/core';
import { MatPaginator } from '@angular/material/paginator';
import { MatTableDataSource } from '@angular/material/table';
import {MemberApiService} from "../../../../services/api/member.api.service";
import { Router } from '@angular/router';

@Component({
  selector: 'app-member-list',
  templateUrl: './member-list.component.html',
  styleUrls: ['./member-list.component.scss']
})
export class MemberListComponent implements AfterViewInit {

  searchQuery: string = '';
  selectedSort: string = 'newest';
  hideInactive: boolean = false;
  displayedColumns: string[] = ['name', 'did', 'type', 'status'];
  dataSource = new MatTableDataSource<Member>();
  totalLength = 10;

  constructor(private readonly memberApiService: MemberApiService, private router: Router ) {
    this.getData();
  }

  @ViewChild(MatPaginator) paginator!: MatPaginator;
  ngAfterViewInit() {
    this.dataSource.paginator = this.paginator;
  }

  applyFilter(): void {
    this.dataSource.filter = this.searchQuery.trim().toLowerCase();
  }

  getData(): void {
    this.dataSource = new MatTableDataSource<Member>(MEMBER_DATA);
        this.totalLength = MEMBER_DATA.length;
  }

  sortData(): void {
    // Implement sorting logic based on selectedSort
  }

  filterData(): void {
    // Implement filtering logic based on hideInactive
  }

  onPageChange(event: any): void {
    // Implement pagination logic
  }

  getStatusClass(act: string): string {
    switch (act) {
      case 'onboarded': return 'onboarded';
      case 'pending': return 'pending';
      case 'offboarded': return 'offboarded';
      default: return 'offboarded';
    }
  }

  get breadcrumbs(): { url: () => void; label: string }[] {
    return [
      // { url: () => this.router.navigate(['/member-list']), label: 'List' },
    ];
  }
}

export interface Member {
  name: string;
  did: string;
  type: string;
  act: string;
}

const MEMBER_DATA: Member[] = [
  { name: 'Some Federation Authority', did: 'did:gktc:2itDAKCERh95uGgKbJNHYP', type: 'AUTHORITY', act: 'ONBOARDED' },
  { name: 'Some Federated Dataspace', did: 'did:ctar:0x3beca30c489d9e26865f', type: 'DATASPACE', act: 'ONBOARDED' },
  { name: 'Some Federated Dataspace', did: 'did:gktc:2itDAKCERh95uGgKbJNHYP', type: 'DATASPACE', act: 'ONBOARDED' },
  { name: 'Some Federated Dataspace', did: 'did:gktc:2itDAKCERh95uGgKbJNHYP', type: 'DATASPACE', act: 'PENDING' },
  { name: 'Some Federated Dataspace', did: 'did:gktc:2itDAKCERh95uGgKbJNHYP', type: 'DATASPACE', act: 'ONBOARDED' },
  { name: 'Some Federated Dataspace', did: 'did:gktc:2itDAKCERh95uGgKbJNHYP', type: 'DATASPACE', act: 'OFFBOARDED' },
  { name: 'Some Federated Dataspace', did: 'did:gktc:2itDAKCERh95uGgKbJNHYP', type: 'DATASPACE', act: 'PENDING' },
  { name: 'Some Federated Dataspace', did: 'did:gktc:2itDAKCERh95uGgKbJNHYP', type: 'DATASPACE', act: 'ONBOARDED' },
  { name: 'Some Federation Authority', did: 'did:gktc:2itDAKCERh95uGgKbJNHYP', type: 'AUTHORITY', act: 'ONBOARDED' },
  { name: 'Some Federated Dataspace', did: 'did:ctar:0x3beca30c489d9e26865f', type: 'DATASPACE', act: 'ONBOARDED' },
  { name: 'Some Federated Dataspace', did: 'did:gktc:2itDAKCERh95uGgKbJNHYP', type: 'DATASPACE', act: 'ONBOARDED' },
  { name: 'Some Federated Dataspace', did: 'did:gktc:2itDAKCERh95uGgKbJNHYP', type: 'DATASPACE', act: 'PENDING' },
  { name: 'Some Federated Dataspace', did: 'did:gktc:2itDAKCERh95uGgKbJNHYP', type: 'DATASPACE', act: 'ONBOARDED' },
  { name: 'Some Federated Dataspace', did: 'did:gktc:2itDAKCERh95uGgKbJNHYP', type: 'DATASPACE', act: 'OFFBOARDED' },
  { name: 'Some Federated Dataspace', did: 'did:gktc:2itDAKCERh95uGgKbJNHYP', type: 'DATASPACE', act: 'PENDING' },
];