import { AfterViewInit, ChangeDetectorRef, Component, OnInit, ViewChild } from '@angular/core';
import { MatPaginator } from '@angular/material/paginator';
import { MatTableDataSource } from '@angular/material/table';
import { Router } from '@angular/router';

@Component({
  selector: 'app-trading-account-details',
  templateUrl: './trading-account-details.component.html',
  styleUrls: ['./trading-account-details.component.scss']
})
export class TradingAccountDetailsComponent implements AfterViewInit {

  constructor(private router: Router, private cdref: ChangeDetectorRef) { }

  @ViewChild(MatPaginator) paginator!: MatPaginator;
  ngAfterViewInit() {
    this.dataSource.paginator = this.paginator;
    this.cdref.detectChanges();
  }

  tradingAccount = {
    tid: '0x4bf053a0cf91e992c3d3f88c8bb9d1563b5e7a5',
    uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9',
    affiliation: 'Some Company',
    accountBalance: 7690.00,
    tradingStatus: 'ENABLED',
    enrolledDate: '10/03/2024 10:23:55',
    lastStatusChange: 'N/A'
  };

  displayedColumns: string[] = ['txid', 'amount', 'oid', 'type', 'ts'];
  dataSource = new MatTableDataSource<Transaction>(TRANSACTION_DATA);
  totalLength = TRANSACTION_DATA.length;

  onPageChange(event: any): void {
    // Implement pagination logic
  }

  getTypeClass(type: string): string {
    switch (type.toLowerCase()) {
      case 'sell': return 'sell';
      case 'buy': return 'buy';
      case 'tokens in': return 'tokens-in';
      case 'tokens out': return 'tokens-out';
      default: return '';
    }
  }

  redirectToPage(): void {
    // this.router.navigate(['/trusted-source-details']);
    window.open('/trusted-source-details', '_blank');
  }

  get breadcrumbs(): { url: () => void; label: string }[] {
    return [
      { url: () => this.router.navigate(['/trader-list']), label: 'List' },
      { url: () => this.router.navigate(['/trader-details']), label: 'Details' },
      { url: () => this.router.navigate(['/trading-account-details']), label: 'Trading' },
    ];
  }
}

export interface Transaction {
  txid: string;
  amount: number;
  oid: string;
  type: string;
  ts: Date;
}

const TRANSACTION_DATA: Transaction[] = [
  { txid: '0627052b56f29129270f3369e1d1ae57', amount: 500.00, oid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', type: 'SELL', ts: new Date('2024-02-24T15:30:00') },
  { txid: '0627052b56f29129270f3369e1d1ae57', amount: 500.00, oid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', type: 'SELL', ts: new Date('2024-02-24T15:30:00') },
  { txid: '0627052b56f29129270f3369e1d1ae57', amount: 500.00, oid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', type: 'BUY', ts: new Date('2024-02-24T15:30:00') },
  { txid: '0627052b56f29129270f3369e1d1ae57', amount: 500.00, oid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', type: 'TOKENS IN', ts: new Date('2024-02-24T15:30:00') },
  { txid: '0627052b56f29129270f3369e1d1ae57', amount: 500.00, oid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', type: 'TOKENS OUT', ts: new Date('2024-02-24T15:30:00') },
  { txid: '0627052b56f29129270f3369e1d1ae57', amount: 500.00, oid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', type: 'BUY', ts: new Date('2024-02-24T15:30:00') },
  { txid: '0627052b56f29129270f3369e1d1ae57', amount: 500.00, oid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', type: 'BUY', ts: new Date('2024-02-24T15:30:00') },
  { txid: '0627052b56f29129270f3369e1d1ae57', amount: 500.00, oid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', type: 'BUY', ts: new Date('2024-02-24T15:30:00') },
  { txid: '0627052b56f29129270f3369e1d1ae57', amount: 500.00, oid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', type: 'SELL', ts: new Date('2024-02-24T15:30:00') },
  { txid: '0627052b56f29129270f3369e1d1ae57', amount: 500.00, oid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', type: 'SELL', ts: new Date('2024-02-24T15:30:00') },
  { txid: '0627052b56f29129270f3369e1d1ae57', amount: 500.00, oid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', type: 'BUY', ts: new Date('2024-02-24T15:30:00') },
  { txid: '0627052b56f29129270f3369e1d1ae57', amount: 500.00, oid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', type: 'TOKENS IN', ts: new Date('2024-02-24T15:30:00') },
  { txid: '0627052b56f29129270f3369e1d1ae57', amount: 500.00, oid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', type: 'TOKENS OUT', ts: new Date('2024-02-24T15:30:00') },
  { txid: '0627052b56f29129270f3369e1d1ae57', amount: 500.00, oid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', type: 'BUY', ts: new Date('2024-02-24T15:30:00') },
  { txid: '0627052b56f29129270f3369e1d1ae57', amount: 500.00, oid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9', type: 'BUY', ts: new Date('2024-02-24T15:30:00') },
];