import { Component, OnInit, ViewChild } from '@angular/core';
import { NgForm } from '@angular/forms';
import { Router } from '@angular/router';

@Component({
  selector: 'app-trading-tokens',
  templateUrl: './trading-tokens.component.html',
  styleUrls: ['./trading-tokens.component.scss']
})
export class TradingTokensComponent implements OnInit {

  constructor(private router: Router) { }

  ngOnInit() {
  }

  @ViewChild('transactionForm') transactionForm!: NgForm;

  tradingAccount = {
    tid: '0x4bf053a0cf91e992c3d3f88c8bb9d1563b5e7a5',
    uid: 'e1c4be79-f8c2-4243-a4f6-b534dd85e8e9',
    affiliation: 'Some Company',
    accountBalance: 7690.00,
    tradingStatus: 'ENABLED'
  };

  transaction = {
    type: 'Send Tokens',
    amount: 100
  };

  transactionTypes: string[] = ['Send Tokens', 'Receive Tokens'];

  onSubmit() {
    if (this.transactionForm.valid) {
      console.log('Transaction Submitted', this.transaction);
    }
  }

  onDiscard() {
    // Implement discard logic if needed
    console.log('Transaction Discarded');
  }

  redirectToPage(): void {
    // this.router.navigate(['/trusted-source-details']);
    window.open('/trusted-source-details', '_blank');
  }

  get breadcrumbs(): { url: () => void; label: string }[] {
    return [
      { url: () => this.router.navigate(['/trader-list']), label: 'List' },
      { url: () => this.router.navigate(['/trader-details']), label: 'Details' },
      { url: () => this.router.navigate(['/trading-account-details']), label: 'Trading' },
      { url: () => this.router.navigate(['/trading-tokens']), label: 'Tokens' },
    ];
  }
}