import { Component, OnInit, ViewChild } from '@angular/core';
import { NgForm } from '@angular/forms';
import { Router } from '@angular/router';

@Component({
  selector: 'app-trusted-source-details',
  templateUrl: './trusted-source-details.component.html',
  styleUrls: ['./trusted-source-details.component.scss']
})
export class TrustedSourceDetailsComponent implements OnInit {

  constructor( private router: Router) { }

  ngOnInit() {
  }

  @ViewChild('trustedSourceForm') trustedSourceForm!: NgForm;

  trustedSource = {
    legalName: 'ACME Business Insights, Inc.',
    tid: 'ccbad0c3-76ce-43f5-8482-9779a40f4bfa',
    streetAddress1: 'TEST',
    streetAddress2: 'TEST',
    streetAddress3: 'TEST',
    city: 'john@doe.com',
    postcode: '26/03/2024',
    region: '2',
    country: '3',
    lei: '10',
    tin: '10',
    bic: '10',
    dun: '10',
    onboardedDate: '11/03/2024 12:32:16',
    offboardedDate: 'N/A'
  };

  countries: string[] = ['United States', 'Canada', 'United Kingdom', 'Australia', 'Germany', 'France'];

  onSubmit() {
    if (this.trustedSourceForm.valid) {
      console.log('Form Submitted', this.trustedSource);
    }
  }

  onOffboard() {
    console.log('Offboarded');
  }

  get breadcrumbs(): { url: () => void; label: string }[] {
    return [
      { url: () => this.router.navigate(['/trusted-source-list']), label: 'List' },
      { url: () => this.router.navigate(['/trusted-source-details']), label: 'Details' },
    ];
  }
}