import { Component, OnInit, ViewChild } from '@angular/core';
import { NgForm } from '@angular/forms';
import { Router } from '@angular/router';

@Component({
  selector: 'app-trusted-source-onboarding',
  templateUrl: './trusted-source-onboarding.component.html',
  styleUrls: ['./trusted-source-onboarding.component.scss']
})
export class TrustedSourceOnboardingComponent implements OnInit {

  constructor(private router: Router) { }

  ngOnInit() {
  }

  @ViewChild('trustedSourceForm') trustedSourceForm!: NgForm;

  trustedSource = {
    legalName: 'John',
    streetAddress1: 'TEST',
    streetAddress2: 'TEST',
    streetAddress3: 'TEST',
    city: 'john@doe.com',
    postcode: '26/03/2024',
    region: '2',
    country: '3',
    lei: '10',
    tin: '10',
    bic: '10',
    dun: '10'
  };

  countries: string[] = ['United States', 'Canada', 'United Kingdom', 'Australia', 'Germany', 'France'];

  onSubmit() {
    if (this.trustedSourceForm.valid) {
      console.log('Form Submitted', this.trustedSource);
    }
  }

  onDiscard() {
    // Implement discard logic if needed
    console.log('Form Discarded');
  }

  get breadcrumbs(): { url: () => void; label: string }[] {
    return [
      { url: () => this.router.navigate(['/trusted-source-list']), label: 'List' },
      { url: () => this.router.navigate(['/trusted-source-details']), label: 'Details' },
    ];
  }
}