import { DOCUMENT, ViewportScroller } from '@angular/common';
import { AfterViewInit, Component, OnInit, inject } from '@angular/core';
import { Observable, fromEvent, map } from 'rxjs';

@Component({
  selector: 'app-core-value',
  templateUrl: './core-value.component.html',
  styleUrls: ['./core-value.component.scss']
})
export class CoreValueComponent implements OnInit, AfterViewInit {

  constructor() { }

  ngOnInit() {
  }

  ngAfterViewInit(): void {
    // 1) Create a <script> element
    const script = document.createElement('script');
    script.src = 'https://website-widgets.pages.dev/dist/sienna.min.js';
    script.async = true;  // or false, depending on your needs

    // 2) Optionally run code after the script is fully loaded
    script.onload = () => {
      console.log('Sienna script loaded!');
      // If the script provides a global function, you can call it here
      // e.g. window['Sienna']?.init(...);
    };

    // 3) Append the script to the <body> or <head>
    document.body.appendChild(script);
  }

  private readonly document = inject(DOCUMENT);
  private readonly viewport = inject(ViewportScroller);
  readonly showScroll$: Observable<boolean> = fromEvent(
    this.document,
    'scroll'
  ).pipe(
    map(() => this.viewport.getScrollPosition()?.[1] > 0)
  );

  onScrollToTop(): void {
    this.viewport.scrollToPosition([0, 0]);
  }
}