import { DOCUMENT, ViewportScroller } from '@angular/common';
import { AfterViewInit, Component, OnInit, inject } from '@angular/core';
import { Observable, fromEvent, map } from 'rxjs';

@Component({
  selector: 'app-business-framework',
  templateUrl: './business-framework.component.html',
  styleUrls: ['./business-framework.component.scss']
})
export class BusinessFrameworkComponent implements OnInit, AfterViewInit {

  constructor() { }

  ngOnInit() {
  }

  ngAfterViewInit(): void {
    // 1) Create a <script> element
    const script = document.createElement('script');
    script.src = 'https://website-widgets.pages.dev/dist/sienna.min.js';
    script.async = true;  // or false, depending on your needs
    script.onload = () => {
      console.log('Sienna script loaded!');
    };
    document.body.appendChild(script);
  }

  private readonly document = inject(DOCUMENT);
  private readonly viewport = inject(ViewportScroller);
  readonly showScroll$: Observable<boolean> = fromEvent(
    this.document,
    'scroll'
  ).pipe(
    map(() => this.viewport.getScrollPosition()?.[1] > 0)
  );

  onScrollToTop(): void {
    this.viewport.scrollToPosition([0, 0]);
  }
}