import { AfterViewInit, Component, HostListener, OnInit, ViewChild } from '@angular/core';
import { MatDialog } from '@angular/material/dialog';
import { MatPaginator } from '@angular/material/paginator';
import { MatTableDataSource } from '@angular/material/table';
import { DialogNewTicketComponent } from 'src/app/components/dialog-new-ticket/dialog-new-ticket.component';
import { DialogViewTicketComponent } from 'src/app/components/dialog-view-ticket/dialog-view-ticket.component';

@Component({
  selector: 'app-profile-page-ticket',
  templateUrl: './profile-page-ticket.component.html',
  styleUrls: ['./profile-page-ticket.component.scss']
})

export class ProfilePageTicketComponent implements AfterViewInit {

  dropdownOpen = false;
  selectedOption = 'Newest';
  options = ['Newest', 'Oldest', 'Relevance'];

  dropdownUserOpen = false;
  selectedUserOption = 'Active';
  optionsUser = ['Active', 'Inactive', 'Pending'];

  toggleDropdown() {
    this.dropdownOpen = !this.dropdownOpen;
  }

  selectOption(option: string) {
    this.selectedOption = option;
    this.dropdownOpen = false;
  }

  toggleUserDropdown() {
    this.dropdownUserOpen = !this.dropdownUserOpen;
  }

  selectUserOption(option: string) {
    this.selectedUserOption = option;
    this.dropdownUserOpen = false;
  }

  @HostListener('document:click', ['$event'])
  handleDocumentClick(event: Event) {
    const target = event.target as HTMLElement;
    const clickedInsideSort = target.closest('.dropdown.sort');
    const clickedInsideUser = target.closest('.dropdown.user');

    if (!clickedInsideSort) {
      this.dropdownOpen = false;
    }

    if (!clickedInsideUser) {
      this.dropdownUserOpen = false;
    }
  }

  searchQuery: string = '';
  selectedSort: string = 'newest';
  selectedAccount: string = 'all';
  selectedPriority: string = 'all';
  displayedColumns: string[] = ['ticketId', 'creationDate', 'lastUpdated', 'category', 'status'];
  dataSource = new MatTableDataSource<Ticket>(TICKET_DATA);
  totalLength = TICKET_DATA.length;

  constructor(public dialog: MatDialog) {}
  @ViewChild(MatPaginator) paginator!: MatPaginator;

  ngAfterViewInit() {
    this.dataSource.paginator = this.paginator;
  }

  openDialog(): void {
    const dialogRef = this.dialog.open(DialogNewTicketComponent, {
      width: '800px',
      height: '400px',
      // data: { /* any data you want to pass */ }
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed', result);
    });
  }

  applyFilter(): void {
    this.dataSource.filter = this.searchQuery.trim().toLowerCase();
  }

  sortData(): void {
    // Implement sorting logic based on selectedSort
  }

  filterData(): void {
    // Implement filtering logic based on selectedAccount and selectedPriority
  }

  onPageChange(event: any): void {
    // Implement pagination logic
  }

  getPriorityClass(priority: string): string {
    switch (priority.toLowerCase()) {
      case 'critical': return 'critical';
      case 'high': return 'high';
      case 'medium': return 'medium';
      case 'low': return 'low';
      default: return '';
    }
  }

  openViewDialog(): void {
    const dialogRef = this.dialog.open(DialogViewTicketComponent, {
      width: '800px',
      height: '400px',
      // data: { /* any data you want to pass */ }
    });

    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed', result);
    });
  }
}

export interface Ticket {
  ticketId: string;
  creationDate: Date;
  lastUpdated: Date;
  category: string;
  status: string;
}

const TICKET_DATA: Ticket[] = [
  { ticketId: 'TKT001', creationDate: new Date(), lastUpdated: new Date(), category: 'Technical Support', status: 'Open' },
  { ticketId: 'TKT002', creationDate: new Date(), lastUpdated: new Date(), category: 'Account Management', status: 'Open' },
  { ticketId: 'TKT003', creationDate: new Date(), lastUpdated: new Date(), category: 'Financial Transactions', status: 'Open' },
  { ticketId: 'TKT004', creationDate: new Date(), lastUpdated: new Date(), category: 'Technical Support', status: 'Open' },
  { ticketId: 'TKT005', creationDate: new Date(), lastUpdated: new Date(), category: 'Technical Support', status: 'Open' },
  { ticketId: 'TKT006', creationDate: new Date(), lastUpdated: new Date(), category: 'Technical Support', status: 'Open' },
  { ticketId: 'TKT007', creationDate: new Date(), lastUpdated: new Date(), category: 'Technical Support', status: 'Open' },
  { ticketId: 'TKT008', creationDate: new Date(), lastUpdated: new Date(), category: 'Technical Support', status: 'Open' },
  { ticketId: 'TKT001', creationDate: new Date(), lastUpdated: new Date(), category: 'Technical Support', status: 'Open' },
  { ticketId: 'TKT002', creationDate: new Date(), lastUpdated: new Date(), category: 'Account Management', status: 'Open' },
  { ticketId: 'TKT003', creationDate: new Date(), lastUpdated: new Date(), category: 'Financial Transactions', status: 'Open' },
  { ticketId: 'TKT004', creationDate: new Date(), lastUpdated: new Date(), category: 'Technical Support', status: 'Open' },
  { ticketId: 'TKT005', creationDate: new Date(), lastUpdated: new Date(), category: 'Technical Support', status: 'Open' },
  { ticketId: 'TKT006', creationDate: new Date(), lastUpdated: new Date(), category: 'Technical Support', status: 'Open' },
  { ticketId: 'TKT007', creationDate: new Date(), lastUpdated: new Date(), category: 'Technical Support', status: 'Open' },
  { ticketId: 'TKT008', creationDate: new Date(), lastUpdated: new Date(), category: 'Technical Support', status: 'Open' },
  { ticketId: 'TKT005', creationDate: new Date(), lastUpdated: new Date(), category: 'Technical Support', status: 'Open' },
  { ticketId: 'TKT006', creationDate: new Date(), lastUpdated: new Date(), category: 'Technical Support', status: 'Open' },
  { ticketId: 'TKT007', creationDate: new Date(), lastUpdated: new Date(), category: 'Technical Support', status: 'Open' },
  { ticketId: 'TKT008', creationDate: new Date(), lastUpdated: new Date(), category: 'Technical Support', status: 'Open' },
  { ticketId: 'TKT008', creationDate: new Date(), lastUpdated: new Date(), category: 'Technical Support', status: 'Open' },
  { ticketId: 'TKT001', creationDate: new Date(), lastUpdated: new Date(), category: 'Technical Support', status: 'Open' },
  { ticketId: 'TKT002', creationDate: new Date(), lastUpdated: new Date(), category: 'Account Management', status: 'Open' },
  { ticketId: 'TKT003', creationDate: new Date(), lastUpdated: new Date(), category: 'Financial Transactions', status: 'Open' },
  { ticketId: 'TKT004', creationDate: new Date(), lastUpdated: new Date(), category: 'Technical Support', status: 'Open' },
  { ticketId: 'TKT005', creationDate: new Date(), lastUpdated: new Date(), category: 'Technical Support', status: 'Open' },
  { ticketId: 'TKT006', creationDate: new Date(), lastUpdated: new Date(), category: 'Technical Support', status: 'Open' },
  { ticketId: 'TKT007', creationDate: new Date(), lastUpdated: new Date(), category: 'Technical Support', status: 'Open' },
  { ticketId: 'TKT008', creationDate: new Date(), lastUpdated: new Date(), category: 'Technical Support', status: 'Open' },
  { ticketId: 'TKT005', creationDate: new Date(), lastUpdated: new Date(), category: 'Technical Support', status: 'Open' },
  { ticketId: 'TKT006', creationDate: new Date(), lastUpdated: new Date(), category: 'Technical Support', status: 'Open' },
  { ticketId: 'TKT007', creationDate: new Date(), lastUpdated: new Date(), category: 'Technical Support', status: 'Open' },
  { ticketId: 'TKT008', creationDate: new Date(), lastUpdated: new Date(), category: 'Technical Support', status: 'Open' },
];