import { Injectable } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Observable, throwError } from 'rxjs';
import { catchError, map } from 'rxjs/operators';
export const IOT_CAT_URL = "https://fdac-open-api.fame-horizon.eu"
export const IOT_CAT_TOKEN = "AsKM4XXPihh_yaHRZDdVRxv4orVBReomm3ykAo1IID2"
export const IOT_CAT_CONTEXT = "fame fdac"

@Injectable({
  providedIn: 'root'
})
export class AdvancedSearchService {
  private apiClient;
  private baseURL = IOT_CAT_URL;

  constructor(private http: HttpClient) {
    this.apiClient = {
      baseURL: this.baseURL,
      headers: new HttpHeaders({
        'Content-Type': 'application/json',
        'accept': 'application/json',
        'Authorization': `Bearer ${IOT_CAT_TOKEN}`
      })
    };
  }

  /**
   * Perform a query to the backend API to search for data.
   *
   * @param {Object} data - The data to be sent in the query
   * @returns {Observable<Object>} - An observable that resolves with the data from the response
   * @throws {Error} - If an error occurs during the query
   */
  query(data: any): Observable<any> {
    //const url = `${this.apiClient.baseURL}/api/data/search`;
    const url = `${this.apiClient.baseURL}/searchAssets`;
    // Log the request details
    console.log('Making request to:', url);
    console.log('Request headers:', this.apiClient.headers);
    console.log('Request payload:', data);


    return this.http.post<any>(url, data, { headers: this.apiClient.headers })
      .pipe(
        map(response => response.results),
        catchError(error => {
          console.error('Error fetching data:', error);
          return throwError(error);
        })
      );
  } 
}