/**
 * Asset Details DTO - V2 API Response
 *
 * This interface represents the structure of asset details returned from the
 * provenance API v2 endpoint: /assets/{assetId}
 */
export interface AssetDetails {
    // Required fields
    dcterms_identifier: string;
    dcterms_title: string;
    dcterms_description_short: string;
    dcterms_type: string;
    dcat_endpointURL: string; // Format: "Platform@https://..."
    dcterms_creator: string;

    // Optional fields
    dcterms_description_long?: string;
    fame_logo?: string;
    dcat_landingPage?: string;
    dcterms_conformsTo?: string[];
}

interface TagWithType {
    _id?: string,
    id?: string,
    type: string,
    name: string
}
interface ComponentEntity {
    name: string,
    website: string
}

interface ComponentStandard {
    name: string,
    developedBy: ComponentEntity
}
interface ComponentDocumentation {
    url: string,
    title: string,
    description?: string
}

interface ComponentReference {
    documentation?: ComponentDocumentation,
    accessPlatforms?: ComponentDocumentation,
    repositories?: string[]
}
export interface CanonicalAsset {
    "website"?: string,
    "name"?: string,
    "description": string,
    "longDescription": string,
    "summary": string,
    "type": string,
    "license": string,
    "tags"?: TagWithType[],
    "manufacturers"?: ComponentEntity,
    "developers"?: ComponentEntity,
    "standards"?: ComponentStandard,
    "trl"?: number,
    "references"?: ComponentReference,
    version: string,
    pid?: string | number
}

export interface AssetLineageTracing {
    aid: string,
    entry: CanonicalAsset,
    hash: string,
    tid: string,
    registered: string,
    trustworthy: boolean,
    lineage?: string
}