import { Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { environment } from '../../../environments/environment';
import { Address } from 'viem';
import { Observable } from 'rxjs';
import { EnroledAccountsRespDto } from './dtos/enroled-accounts.resp.dto';
import { ActiveMemberRespDto } from './dtos/active-member.resp.dto';
import { StatsRespDto } from './dtos/stats.resp.dto';

@Injectable({
  providedIn: 'root',
})
export class GovernanceApiService {
  private url = environment.govUrl;
  constructor(private httpClient: HttpClient) {}

  enrolAddress(address: Address) {
    return this.httpClient.post(this.url + 'accounts', {
      tid: address,
    });
  }

  getEnrolledAccounts(): Observable<EnroledAccountsRespDto[]> {
    return this.httpClient.get<EnroledAccountsRespDto[]>(this.url + 'active-accounts');
  }

  public checkRequestStatus(requestId: string) {
    const url = this.url + 'requests/' + requestId;
    return this.httpClient.get(url);
  }

  /** Fetch the “active member” record for a given pid */
  getActiveMember(pid: string): Observable<ActiveMemberRespDto> {
    return this.httpClient.get<ActiveMemberRespDto>(
      `${this.url}active-members/${pid}`
    );
  }

  getStats(): Observable<StatsRespDto> {
    return this.httpClient.get<StatsRespDto>(`${this.url}stats`);
  }
}