import { Injectable } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { environment } from '../../../environments/environment';

@Injectable({
  providedIn: 'root',
})
export class PatApiService {
  private url = environment.patUrl;
  constructor(private httpClient: HttpClient) {}

  public retrieveQuestions(request: any) {
    let headers = new HttpHeaders();
    headers = headers.set('Accept', 'application/json');
    return this.httpClient.get(
      this.url + 'pricing-params?base58=' + request,
      { headers: headers }
    );
  }

  public calculatePrice(questionnaireCompiled: any) {
    let headers = new HttpHeaders();
    headers = headers.set('Accept', 'application/json');
    return this.httpClient.get(
      this.url + 'pricing-advice?base58=' + questionnaireCompiled,
      { headers: headers }
    );
  }
}