import { Injectable } from '@angular/core';
import { BehaviorSubject } from 'rxjs';

@Injectable({
  providedIn: 'root'
})
export class ChatService {
  private chatbotVisible = new BehaviorSubject<boolean>(false);
  chatbotVisible$ = this.chatbotVisible.asObservable();

  toggleChatbot() {
    this.chatbotVisible.next(!this.chatbotVisible.value);
  }

  closeChatbot() {
    this.chatbotVisible.next(false);
  }

  openChatbot() {
    this.chatbotVisible.next(true);
  }
}