import { Injectable } from '@angular/core';
import { HttpRequest, HttpHandler, HttpEvent, HttpInterceptor } from '@angular/common/http';
import { Observable } from 'rxjs';
import { AuthService } from '../auth/auth.service';
import { Router } from '@angular/router';

@Injectable()
export class HeaderInterceptor implements HttpInterceptor {
  constructor(private authService: AuthService, private router: Router) {}

  intercept(request: HttpRequest<any>, next: HttpHandler): Observable<HttpEvent<any>> {
    const token = this.authService.getToken();
    const currentUrl = this.router.url;

    // Define routes where you don't want to set the Authorization header
    const excludedRoutes = ['/fdac', '/learning-centre', '/search'];

    // Check if the current route is in the excluded routes
    const isExcludedRoute = excludedRoutes.some(route => currentUrl.includes(route));

    const modifiedRequest = request.clone({
      setHeaders: {
        'Content-Type': 'application/json',
        // Conditionally set the Authorization header
        ...(token && !isExcludedRoute ? { 'Authorization': `Bearer ${token}` } : {})
      },
    });

    return next.handle(modifiedRequest);
  }
}