// snackbar.service.ts
import { Injectable } from '@angular/core';
import {
  MatSnackBar,
  MatSnackBarConfig,
  MatSnackBarRef,
  SimpleSnackBar
} from '@angular/material/snack-bar';

@Injectable({ providedIn: 'root' })
export class SnackbarService {
  constructor(private snackBar: MatSnackBar) {}

  openSnackBar(
    message: string,
    action: string,
    config: MatSnackBarConfig
  ): MatSnackBarRef<SimpleSnackBar> {
    return this.snackBar.open(message, action, config);
  }

  success(
    message: string,
    action: string = '',
    duration: number = 3000
  ): MatSnackBarRef<SimpleSnackBar> {
    return this.openSnackBar(message, action, {
      duration,
      panelClass: ['snackbar-success']
    });
  }

  error(
    message: string,
    action: string = '',
    duration: number = 3000
  ): MatSnackBarRef<SimpleSnackBar> {
    return this.openSnackBar(message, action, {
      duration,
      panelClass: ['snackbar-error']
    });
  }

  warning(
    message: string,
    action: string = '',
    duration: number = 3000
  ): MatSnackBarRef<SimpleSnackBar> {
    return this.openSnackBar(message, action, {
      duration,
      panelClass: ['snackbar-warning']
    });
  }

  info(
    message: string,
    action: string = '',
    duration: number = 3000
  ): MatSnackBarRef<SimpleSnackBar> {
    return this.openSnackBar(message, action, {
      duration,
      panelClass: ['snackbar-info']
    });
  }
}