import { AbstractControl, ValidationErrors, ValidatorFn } from '@angular/forms';
import { isAddress } from 'viem';

export function IsEthAddressValidator(): ValidatorFn {
  return (control: AbstractControl): ValidationErrors | null => {
    const value: string = control.value;

    // If the control is empty, don't validate yet (handle with required validator)
    if (!value) {
      return null;
    }

    // Use Viem's isAddress function to validate the Ethereum address
    const valid = isAddress(value);

    // If valid, return null (no error), else return an error object
    return valid ? null : { invalidEthAddress: true };
  };
}