// This file can be replaced during build by using the `fileReplacements` array.
// `ng build` replaces `environment.ts` with `environment.prod.ts`.
// The list of file replacements can be found in `angular.json`.

export const environment = {
  production: false,
  qrCodeExpiresAfterSec: 300,
  presentationDefId: 'FAMEv1',
  authenticationEnabled: true,
  authenticationStaticToken: 'demo',
  chainId: 6666,
  marketplaceUrl: 'http://localhost:4200',

  // URLs pointing to local development instances of core FAME services:
  // govUrl: 'http://gov.fame.local/api/v1.0/',
  // ptUrl: 'http://pt.fame.local/api/v1.0/',
  // patUrl: 'http://pat.fame.local/pat/v1.0/',
  // tmUrl: 'http://tm.fame.local/api/v1.0/',

  // URLs pointing to deployed core FAME services that support CORS:
  govUrl: 'https://gov.fame-horizon.eu/api/v1.0/',
  ptUrl: 'https://pt.fame-horizon.eu/api/v1.0/',
  tmUrl: 'https://tm.fame-horizon.eu/api/v1.0/',
  identityUrl: 'https://identity.fame-horizon.eu',
  authAPIUrl: 'https://auth.fame-horizon.eu/',
  apmUIURL: "https://apm-ui.fame-horizon.eu",

  // proxied URLs pointing to deployed services that do not support CORS:
  federationStatsEndpoint: '/api/public/federation-stats',
  openAPIURL: "/fdac-api",
  searchUrl: '/search-api/api/',
  apmURL: "/apm-api",
  patUrl: '/pat-api/pat/v1.0/'
};

/*
 * For easier debugging in development mode, you can import the following file
 * to ignore zone related error stack frames such as `zone.run`, `zoneDelegate.invokeTask`.
 *
 * This import should be commented out in production mode because it will have a negative impact
 * on performance if an error is thrown.
 */
// import 'zone.js/plugins/zone-error';  // Included with Angular CLI.