# FFGA - FAME Federation Governance Application

[![License](https://img.shields.io/badge/License-Apache%202.0-blue.svg)](https://opensource.org/licenses/Apache-2.0)
[![Python](https://img.shields.io/badge/python-3.13-blue.svg)](https://www.python.org/downloads/)
[![Flask](https://img.shields.io/badge/flask-latest-green.svg)](https://flask.palletsprojects.com/)

**FFGA** (FAME Federation Governance Application) is the democratic governance platform for the FAME federated marketplace. It manages the onboarding process for organizations seeking to join the FAME federation through a transparent, member-driven voting system.

## About FAME

FAME is a Horizon Europe project that aims to create a federated marketplace for trading financial, research, and industrial data assets. The project ensures compliance with EU regulations (GDPR, Data Act, Data Governance Act, AI Act) while building a trusted community that respects codes of conduct and Sustainable Development Goals (SDGs).

## Purpose

FFGA manages the democratic process of onboarding organizations that want to join the FAME marketplace federation. Its main objectives are:

- **Manage organization applications** for federation membership
- **Facilitate voting processes** by existing federation members
- **Ensure EU regulatory compliance** (GDPR, Data Act, Data Governance Act, AI Act)
- **Build a trusted community** that respects codes of conduct and SDGs

## Target Audience

- **Applicant Organizations**: Business organizations, universities, government entities, non-profits, and research institutions seeking federation membership
- **Federation Governance Board (FGB)**: Federated members with voting rights on new applications
- **Legal Representatives**: Authorized persons representing their organizations
- **Platform Administrators**: System management and oversight

## Key Features

### Core Functionality
- **User Authentication & Authorization**: Email-based verification with role-based access control
- **Organization Management**: Complete onboarding and approval workflows
- **Democratic Voting System**: Time-bound voting on federation applications with configurable thresholds
- **Document Management**: Secure upload and verification of legal authorization documents
- **DID Management**: Decentralized Identifiers for Onboarding Authorities

### Advanced Features
- **Multi-organization Type Support**: Special handling for European Projects (EUP), Research Organizations, and Business entities
- **Automated Expiry Checks**: Background scheduler for vote deadline monitoring
- **Email Notification System**: Automated communications for applications, voting, and results
- **Control Panel**: Self-service management for federated members and their users
- **Logo & Website Management**: Organization branding capabilities
- **GDPR Compliance**: Privacy-first data handling and user consent management

### Integration
- **FAME Marketplace Platform API (FMAP)**: Synchronization of federated organizations and users
- **RESTful API**: Internal and public endpoints for system integration
- **Marketplace User Integration**: Connect with FAME marketplace accounts

## Technology Stack

- **Backend**: Flask (Python 3.13)
- **Database**: SQLAlchemy with SQLite (development) / PostgreSQL (production recommended)
- **Scheduler**: APScheduler for background jobs
- **Email**: SMTP integration with Gmail support
- **Frontend**: Jinja2 templates with responsive HTML/CSS

## Project Structure

```
ffga-fame-federation-goverance-application/
├── app/
│   ├── models/           # Database models (User, Organization, Vote, Document)
│   ├── routes/           # Flask blueprints (auth, api, main, internal_api, public_api)
│   ├── services/         # Business logic layer
│   ├── templates/        # Jinja2 HTML templates
│   ├── utils/            # Utility functions and decorators
│   ├── config.py         # Configuration management
│   └── __init__.py       # Application factory
├── data/
│   ├── db/              # SQLite database files
│   ├── uploads/         # Document uploads
│   └── logos/           # Organization logos
├── migration/           # Database migration scripts
├── run.py              # Application entry point
└── populate_db.py      # Database seeding script
```

## Installation

### Prerequisites

- Python 3.13 or higher
- pip (Python package manager)
- Virtual environment (recommended)

### Setup

1. **Clone the repository**
   ```bash
   git clone https://gitlab.gftinnovation.eu/fame/ffga-fame-federation-goverance-application.git
   cd ffga-fame-federation-goverance-application
   ```

2. **Create and activate virtual environment**
   ```bash
   python -m venv venv

   # Windows
   venv\Scripts\activate

   # Linux/Mac
   source venv/bin/activate
   ```

3. **Install dependencies**
   ```bash
   pip install -r requirements.txt
   ```

4. **Configure environment variables**

   Create a `.env` file or set the following environment variables:
   ```bash
   SECRET_KEY=your-secret-key-here
   DATABASE_URL=sqlite:///data/db/database.db  # or PostgreSQL URL
   FAME_API_BASE_URL=https://gov.fame-horizon.eu
   FAME_API_KEY=your-api-key
   MAIL_SERVER=smtp.gmail.com
   MAIL_USERNAME=your-email@example.com
   MAIL_PASSWORD=your-app-password
   ```

5. **Initialize the database**

   The database will be automatically created on first run, including an initial GFT organization and user.

6. **Run the application**
   ```bash
   python run.py
   ```

   The application will be available at `http://localhost:5000`

## Configuration

Configuration is managed through `app/config.py` with three environments:

- **Development**: Debug enabled, local mail server, relaxed security
- **Production**: Debug disabled, secure sessions, production mail settings
- **Testing**: In-memory database, CSRF disabled

### Key Configuration Options

| Setting | Description | Default |
|---------|-------------|---------|
| `VOTING_DURATION_MINUTES` | Duration for voting period | 4320 (3 days) |
| `MINIMUM_VOTES_REQUIRED` | Minimum votes needed for decision | 1 |
| `APPROVAL_THRESHOLD` | Percentage needed for approval | 0.5 (50%) |
| `MAX_CONTENT_LENGTH` | Maximum upload file size | 10MB |
| `ALLOWED_EXTENSIONS` | Allowed document formats | pdf, doc, docx |
| `EMAIL_CONFIRMATION_EXPIRY_HOURS` | Email confirmation validity | 24 hours |

## Usage

### For Applicant Organizations

1. **Register** an account with your organization details
2. **Verify** your email address
3. **Complete** the organization onboarding form
4. **Upload** legal authorization documents
5. **Submit** your application for FGB review
6. **Wait** for the voting period to complete

### For Federation Members (FGB)

1. **Login** with your federated member credentials
2. **Review** pending organization applications
3. **Cast votes** (approve/reject) with optional comments
4. **Manage** your organization's marketplace users
5. **Monitor** voting results and federation status

### For Administrators

1. Access the **internal API** for system management
2. Monitor **organization status** and voting progress
3. Manage **user accounts** and permissions
4. Review **system logs** and audit trails

## API Documentation


### Internal API (Requires Authentication)
- `POST /internal/marketplace-users` - Create/update marketplace users
- `GET /internal/organization/<id>` - Get organization details
- Various management endpoints for system administration

### Main API (`/api/v1`)
- Organization management endpoints
- Voting endpoints
- Document management endpoints
- User management endpoints

## Deployment

**[DEPLOYMENT INSTRUCTIONS TO BE ADDED]**

This section will include:
- Docker deployment instructions
- Production server setup
- Database migration procedures
- SSL/TLS configuration
- Load balancing considerations
- Backup and recovery procedures

## External Dependencies

### Required Services

1. **FAME Marketplace Platform API (FMAP)**
   - Endpoint: `https://gov.fame-horizon.eu/api/1.0/members`
   - Purpose: Registration and synchronization of federated organizations
   - Authentication: Bearer token required

2. **Email Service**
   - SMTP server for email notifications
   - Configured for Gmail by default (configurable)

## Security Considerations

- **HTTPS Required**: All production deployments must use HTTPS
- **Session Security**: Secure, HTTP-only cookies with configurable lifetime
- **Email Verification**: Mandatory email confirmation for new users
- **Password Security**: Hashed passwords with secure storage
- **File Upload Validation**: Strict file type and size restrictions
- **CSRF Protection**: Cross-Site Request Forgery protection on all forms
- **SQL Injection Prevention**: SQLAlchemy ORM with parameterized queries

## Database Schema

### Main Models

- **User**: Authentication and user profile information
- **Organization**: Federation member organization details
- **PostalAddress**: Organization physical addresses
- **Vote**: Voting records for organization applications
- **Document**: Legal authorization documents
- **MarketplaceUser**: Users synchronized with FAME marketplace

## Background Jobs

The application runs scheduled background jobs using APScheduler:

- **Vote Expiry Check**: Runs every 10 minutes to identify and process expired voting periods

## Email Notifications

Automated emails are sent for:
- Email address verification
- Organization application submission
- Voting invitations to FGB members
- Voting results (approval/rejection)
- Password reset requests

## Contributing

This project is part of the FAME Horizon Europe initiative. Contributions are welcome following these guidelines:

1. Fork the repository
2. Create a feature branch (`git checkout -b feature/AmazingFeature`)
3. Commit your changes (`git commit -m 'Add some AmazingFeature'`)
4. Push to the branch (`git push origin feature/AmazingFeature`)
5. Open a Merge Request

### Code Standards

- Follow PEP 8 style guidelines for Python code
- Add docstrings to all functions and classes
- Include unit tests for new features
- Update documentation as needed


## Troubleshooting

### Common Issues

**Database errors on first run**
- Ensure the `data/db` directory exists and is writable
- Check database URL configuration

**Email sending failures**
- Verify SMTP credentials and server settings
- Check firewall rules for SMTP port (587/465)
- For Gmail, use App Passwords instead of account password

**API integration errors**
- Verify FAME_API_BASE_URL and FAME_API_KEY configuration
- Check network connectivity to external API
- Review API logs for authentication issues

**Vote expiry not processing**
- Ensure the APScheduler is running (check application logs)
- Verify system time is correct

## Support

For support and inquiries:
- **Email**: support@fame-horizon.eu
- **Issue Tracker**: [GitLab Issues](https://gitlab.gftinnovation.eu/fame/ffga-fame-federation-goverance-application/-/issues)

## License

This project is licensed under the Apache License 2.0 - see the [LICENSE](LICENSE) file for details.

```
Copyright 2024 FAME Consortium

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```

## Acknowledgments

This project is part of the **FAME (Federated AI-enabled Open Marketplace for Europe)** project, funded by the European Union's Horizon Europe research and innovation program.

- **Project Website**: https://fame-horizon.eu
- **EU Program**: Horizon Europe

## Project Status

Active development - Version 1.0 (MVP)

The FFGA is currently in active development as part of the FAME project deliverables. Regular updates and improvements are being made to enhance functionality, security, and user experience.

## Roadmap

- Enhanced analytics dashboard for voting statistics
- Multi-language support for international organizations
- Advanced document verification workflows
- Integration with additional EU identity verification services
- Mobile-responsive UI improvements
- API rate limiting and caching
- Enhanced audit logging and compliance reporting

---
