# app/config.py
import os
from datetime import timedelta

class Config:
    # Basic Flask config
    SECRET_KEY = os.environ.get('SECRET_KEY') or 'your-secret-key'

    # Definition of paths for data and uploads directories
    BASE_DIR = os.path.abspath(os.path.dirname(os.path.dirname(__file__)))    
    DATA_DIR = os.path.join(BASE_DIR, 'data')    
    DB_DIR = os.path.join(DATA_DIR, 'db')    

    # Database configuration
    SQLALCHEMY_DATABASE_URI = os.environ.get('DATABASE_URL') or \
                        'sqlite:///' + os.path.join(DB_DIR, 'database.db')
    SQLALCHEMY_TRACK_MODIFICATIONS = False   
    
    # Configuration for the external API
    FAME_API_BASE_URL = 'http://gov-internal:7008/gov'
    FAME_API_KEY = 'your_api_key_here'  # Replace with your API key
    
    # Internal API settings
    INTERNAL_API_USERNAME = 'admin'
    INTERNAL_API_PASSWORD = 'GiulianoMatteo'
    
    # Federation settings
    VOTING_DURATION_MINUTES = 4320  # 3 days
    MINIMUM_VOTES_REQUIRED = 1
    APPROVAL_THRESHOLD = 0.5  # 50% for approval
    
    # File upload settings
    UPLOAD_FOLDER = os.path.join(DATA_DIR, 'uploads')
    MAX_CONTENT_LENGTH = 10 * 1024 * 1024  # 10MB max file size
    ALLOWED_EXTENSIONS = {'pdf', 'doc', 'docx'}
    
    # NEW: Logo directory
    LOGO_FOLDER = os.path.join(DATA_DIR, 'logos')
    
    # Logo configuration
    ALLOWED_LOGO_EXTENSIONS = {'png', 'jpg', 'jpeg', 'svg'}
    MAX_LOGO_SIZE = 2 * 1024 * 1024  # 2MB max file size
    
    # Session settings
    PERMANENT_SESSION_LIFETIME = timedelta(days=1)
    SESSION_COOKIE_SECURE = True
    SESSION_COOKIE_HTTPONLY = True
    
    # Email verification settings
    EMAIL_CONFIRMATION_REQUIRED = True
    EMAIL_CONFIRMATION_EXPIRY_HOURS = 24
    
    # Email sending settings
    MAIL_SERVER = 'smtp.gmail.com'
    GMAIL_TOKEN = "ocdd cixw mwxl eviw"
    MAIL_PORT = 587
    MAIL_USE_TLS = True
    MAIL_USERNAME = 'fb8b80b21e8f33'
    MAIL_PASSWORD = 'f5829f79f1adb2'  # Must be set via environment variable
    MAIL_SUPPRESS_SEND = False  # Set to True to log emails instead of sending
    
    # Email sending settings
    EMAIL_SENDER = "service@fame-horizon.eu"
    EMAIL_SENDER_NAME = "FAME FEDERATION"
    EMAIL_NOREPLY = "no-reply@gftinnovation.eu"

class DevelopmentConfig(Config):
    DEBUG = True
    SESSION_COOKIE_SECURE = False
    
    # Overrides email settings for the development environment
    MAIL_SERVER = 'localhost'
    MAIL_PORT = 1025
    MAIL_USE_TLS = False
    MAIL_USERNAME = None
    MAIL_PASSWORD = None
    MAIL_SUPPRESS_SEND = True  # Log instead of sending in development
    
class ProductionConfig(Config):
    DEBUG = False
    # Add production specific settings

class TestingConfig(Config):
    TESTING = True
    SQLALCHEMY_DATABASE_URI = 'sqlite:///:memory:'
    WTF_CSRF_ENABLED = False

config = {
    'development': DevelopmentConfig,
    'production': ProductionConfig,
    'testing': TestingConfig,
    'default': DevelopmentConfig
}