# app/models/marketplace_user.py
from datetime import datetime
from .. import db

class MarketplaceUser(db.Model):
    __tablename__ = 'marketplace_users'

    id = db.Column(db.Integer, primary_key=True)
    first_name = db.Column(db.String(100), nullable=False)
    last_name = db.Column(db.String(100), nullable=False)
    email = db.Column(db.String(120), nullable=False, index=True)
    nickname = db.Column(db.String(15), nullable=True)
    phone = db.Column(db.String(50), nullable=True)
    role = db.Column(db.String(20), nullable=False, default="user")
    sync = db.Column(db.Boolean, default=False)
    created_at = db.Column(db.DateTime, default=datetime.utcnow)
    
    status = db.Column(db.String(20), nullable=False, default="invited")
    
    # Nuovo campo per memorizzare l'UID dell'API esterna
    external_uid = db.Column(db.String(50), nullable=True, unique=True)
    
    # Relazione con Organization
    organization_id = db.Column(db.Integer, db.ForeignKey('organizations.id'), nullable=False)
    
    def to_dict(self):
        return {
            'id': self.id,
            'organization_id': self.organization_id,
            'first_name': self.first_name,
            'last_name': self.last_name,
            'email': self.email,
            'nickname': self.nickname,
            'phone': self.phone,
            'role': self.role,
            'sync': self.sync,
            'status': self.status,
            'external_uid': self.external_uid,
            'created_at': self.created_at.isoformat() if self.created_at else None
        }