# app/routes/main.py
from flask import Blueprint, render_template, session, jsonify, send_from_directory, current_app
from sqlalchemy.orm import joinedload
from ..services import OrganizationService
from ..models import User, Organization
from ..utils.decorators import nocache

main = Blueprint('main', __name__)

@main.route('/')
@nocache
def home():
    user = None
    if 'user_id' in session:
        user = User.query.get(session['user_id'])
    return render_template('home.html', user=user)

@main.route('/faq')
@nocache
def faq():
    user = None
    if 'user_id' in session:
        user = User.query.get(session['user_id'])
    return render_template('faq.html', user=user)

@main.route('/privacy')
@nocache
def privacy():
    user = None
    if 'user_id' in session:
        user = User.query.get(session['user_id'])
    return render_template('privacy.html', user=user)

@main.route('/terms')
@nocache
def terms():
    user = None
    if 'user_id' in session:
        user = User.query.get(session['user_id'])
    return render_template('terms.html', user=user)

@main.route('/federation-rules')
@nocache
def federation_rules():
    user = None
    if 'user_id' in session:
        user = User.query.get(session['user_id'])
    return render_template('federation_rules.html', user=user)

@main.route('/value-propositions')
@nocache
def value_propositions():
    user = None
    if 'user_id' in session:
        user = User.query.get(session['user_id'])
    return render_template('value_propositions.html', user=user)

@main.route('/trusted-community')
@nocache
def trusted_community():
    user = None
    if 'user_id' in session:
        user = User.query.get(session['user_id'])

    # Fetch approved organizations WITH their postal addresses using eager loading
    federated_organizations = Organization.query.options(
        joinedload(Organization.legal_address)
    ).filter_by(
        status='approved',
        offboarded_at=None
    ).order_by(Organization.legal_name).all()

    return render_template('trusted_community.html',
                          user=user,
                          federated_organizations=federated_organizations)

@main.route('/wallet-download')
@nocache
def wallet_download():
    user = None
    if 'user_id' in session:
        user = User.query.get(session['user_id'])
    return render_template('wallet_download.html', user=user)

@main.route('/organizations', methods=['GET'])
def get_organizations():
    organizations = OrganizationService.get_pending_organizations()
    return jsonify([org.to_dict() for org in organizations]), 200

@main.route('/logos/<path:filename>')
def serve_logo(filename):
    """Serve logo files from the logos directory"""
    logo_folder = current_app.config.get('LOGO_FOLDER')
    
    # Security check: prevent directory traversal
    if '..' in filename or filename.startswith('/'):
        return "Invalid filename", 400
    
    return send_from_directory(logo_folder, filename)