# app/utils/test_api_proxy.py
import requests
from flask import current_app

def simulate_api_call(api_user_data):
    """
    Chiama il proxy interno con dati che genereranno un errore specifico.
    Restituisce la risposta così com'è, senza alcuna elaborazione.
    
    Args:
        api_user_data (dict): I dati utente originali
        error_type (str): Tipo di errore da simulare ('phone', 'email', o 'name')
    
    Returns:
        tuple: (response_data, error_message) seguendo lo stesso formato di MemberService.create_user
    """
    # Configurazione del proxy
    proxy_endpoint = "https://federation.fame-horizon.eu/api/proxy"
    auth_username = current_app.config.get('INTERNAL_API_USERNAME', 'admin')
    auth_password = current_app.config.get('INTERNAL_API_PASSWORD', 'GiulianoMatteo')
    
    # Prepara i dati da inviare
    data = {
        "role": api_user_data.get("role", "user"),
        "country": api_user_data.get("country", "IT"),
        "affiliation": api_user_data.get("affiliation", "w5xQXA2f22UEzLGf9z9000"),
        "contact": {
            "firstName": api_user_data.get("contact", {}).get("firstName", "TestName"),
            "lastName": api_user_data.get("contact", {}).get("lastName", "TestLastName"),
            "email": api_user_data.get("contact", {}).get("email", "test@example.com")
        }
    }
    
    # Aggiungi nickname se presente
    if "nickname" in api_user_data:
        data["nickname"] = api_user_data["nickname"]
    
    if "contact" in api_user_data and "phone" in api_user_data["contact"]:
        data["contact"]["phone"] = api_user_data["contact"]["phone"]
    
    
    # Prepara la richiesta per il proxy
    payload = {
        "method": "POST",
        "url": "http://gov-internal:7008/gov/v1.0/users",
        "headers": {
            "Content-Type": "application/json",
            "Authorization": "Bearer your_api_key_here"
        },
        "data": data
    }
    
    
    # Stampa il payload a video
    print("Payload inviato al proxy:", payload)
    
    try:
        # Esegui la richiesta al proxy
        response = requests.post(
            proxy_endpoint,
            json=payload,
            auth=(auth_username, auth_password),
            timeout=10
        )
        
        if response.status_code == 202:  # Accettato
            return response.json(), None
        else:
            return None, f"Errore {response.status_code}: {response.text}"
    except Exception as e:
        return None, str(e)
