from app import create_app, db
from app.models import User, Organization, Vote, PostalAddress
from datetime import datetime, timedelta
import uuid
from datetime import UTC  # Per risolvere il warning di deprecazione

app = create_app()

with app.app_context():
    # Crea utenti di test con email già confermata
    user1 = User(
        first_name='Alice',
        last_name='Testing',
        email='alice@example.com',
        password='Test123!',
        phone='+39 1234567890',
        email_confirmed=True  # Email già confermata
    )
    
    user2 = User(
        first_name='Bob',
        last_name='Approver',
        email='bob@acme.com',
        password='Test123!',
        phone='+44 9876543210',
        email_confirmed=True  # Email già confermata
    )

    user3 = User(
        first_name='Carol',
        last_name='Manager',
        email='carol@techcorp.com', 
        password='Test123!',
        phone='+1 5551234567',
        email_confirmed=True  # Email già confermata
    )

    user4 = User(
        first_name='Dave',
        last_name='Voter',
        email='dave@votecorp.com',
        password='Test123!',
        phone='+49 3214567890',
        email_confirmed=True  # Email già confermata
    )

    user5 = User(
        first_name='Emma',
        last_name='Reviewer',
        email='emma@revieworg.com',
        password='Test123!',
        phone='+33 6789012345',
        email_confirmed=True  # Email già confermata
    )

    # Aggiunge gli utenti al database
    db.session.add_all([user1, user2, user3, user4, user5])
    db.session.flush()  # Ottieni gli ID senza fare commit

    # Crea organizzazioni di test con il nuovo schema
    
    # Organizzazione 1: Autonomous OA (Approved)
    org1 = Organization(
        pid=str(uuid.uuid4()),
        legal_name='Test Organization',
        org_type='FPO',
        did='did:example:123',
        oa_status='OA',
        representative_id=user1.id,
        status='approved',
        onboarded_at=datetime.now(UTC) - timedelta(days=30),
        tin='123456789'
    )

    # Aggiungi org1 al db per ottenere il suo ID
    db.session.add(org1)
    db.session.flush()

    # Organizzazione 2: Delegated to FAME ROA (Approved)
    org2 = Organization(
        pid=str(uuid.uuid4()),
        legal_name='ACME Corp',
        org_type='NPO',
        oa_status='FAME_ROA',
        representative_id=user2.id,
        status='approved',
        onboarded_at=datetime.now(UTC) - timedelta(days=20),
        tin='987654321'
    )

    # Organizzazione 3: Delegated to another OA (Approved)
    # Ora possiamo usare il PID di org1 come delegate_authority_pid
    org3 = Organization(
        pid=str(uuid.uuid4()),
        legal_name='TechCorp Solutions',
        org_type='RES',
        oa_status='DELEGATE',
        delegate_authority_pid=org1.pid,  # Ora abbiamo il PID di org1
        representative_id=user3.id,
        status='approved',
        onboarded_at=datetime.now(UTC) - timedelta(days=15),
        tin='456789123'
    )

    # Organizzazione 4: Pending approval
    org4 = Organization(
        pid=str(uuid.uuid4()),
        legal_name='VoteCorp Inc',
        org_type='EDU',
        oa_status='FAME_ROA',
        representative_id=user4.id,
        status='pending',
        voting_ends_at=datetime.now(UTC) + timedelta(days=2),
        tin='789123456'
    )

    # Organizzazione 5: Pending approval (altro esempio per votazione)
    org5 = Organization(
        pid=str(uuid.uuid4()),
        legal_name='Review Organization',
        org_type='PUB',
        oa_status='FAME_ROA',
        representative_id=user5.id,
        status='pending',
        voting_ends_at=datetime.now(UTC) + timedelta(days=1),
        tin='321654987'
    )

    # Aggiunge le organizzazioni al database
    db.session.add_all([org2, org3, org4, org5])
    db.session.flush()  # Ottieni gli ID
    
    # Crea indirizzi postali per le organizzazioni
    address1 = PostalAddress(
        organization_id=org1.id,
        address_line1='Via Roma 1',
        city='Milano',
        post_code='20121',
        country='IT'
    )
    
    address2 = PostalAddress(
        organization_id=org2.id,
        address_line1='Via Verdi 2',
        city='Roma',
        post_code='00187',
        country='IT'
    )
    
    address3 = PostalAddress(
        organization_id=org3.id,
        address_line1='Via Mazzini 3',
        city='Torino',
        post_code='10123',
        country='IT'
    )
    
    address4 = PostalAddress(
        organization_id=org4.id,
        address_line1='Via Garibaldi 4',
        city='Napoli',
        post_code='80132',
        country='IT'
    )
    
    address5 = PostalAddress(
        organization_id=org5.id,
        address_line1='Via Marconi 5',
        city='Bologna',
        post_code='40121',
        country='IT'
    )
    
    # Aggiunge gli indirizzi postali al database
    db.session.add_all([address1, address2, address3, address4, address5])
    
    # Aggiungi alcuni voti di esempio
    vote1 = Vote(
        organization_id=org4.id,
        voter_id=user1.id,
        vote='yes'
    )
    
    vote2 = Vote(
        organization_id=org4.id,
        voter_id=user2.id,
        vote='yes'
    )
    
    vote3 = Vote(
        organization_id=org5.id,
        voter_id=user1.id,
        vote='no'
    )
    
    # Aggiunge i voti al database
    db.session.add_all([vote1, vote2, vote3])
    
    # Commit finale
    db.session.commit()

    # Stampa utenti di test
    print("Database popolato con successo!")
    print("\nUtenti di test:")
    print(f"- User 1: {user1.first_name} {user1.last_name}, {user1.email} / Test123! (Autonomous OA)")
    print(f"  Phone: {user1.phone}")
    print(f"  Email confermata: Sì")
    print(f"- User 2: {user2.first_name} {user2.last_name}, {user2.email} / Test123! (FAME ROA)")
    print(f"  Phone: {user2.phone}")
    print(f"  Email confermata: Sì")
    print(f"- User 3: {user3.first_name} {user3.last_name}, {user3.email} / Test123! (Delegate OA)")
    print(f"  Phone: {user3.phone}")
    print(f"  Email confermata: Sì")
    print(f"- User 4: {user4.first_name} {user4.last_name}, {user4.email} / Test123! (Pending approval)")
    print(f"  Phone: {user4.phone}")
    print(f"  Email confermata: Sì")
    print(f"- User 5: {user5.first_name} {user5.last_name}, {user5.email} / Test123! (Pending approval)")
    print(f"  Phone: {user5.phone}")
    print(f"  Email confermata: Sì")
    
    print("\nOrganizzazioni di test:")
    print("- Org 1: Test Organization (Approved, Autonomous OA)")
    print("- Org 2: ACME Corp (Approved, FAME ROA)")
    print("- Org 3: TechCorp Solutions (Approved, Delegated to Test Organization)")
    print("- Org 4: VoteCorp Inc (Pending approval)")
    print("- Org 5: Review Organization (Pending approval)")
    
    print("\nVoti di esempio:")
    print("- Alice ha votato 'yes' per VoteCorp Inc")
    print("- Bob ha votato 'yes' per VoteCorp Inc")
    print("- Alice ha votato 'no' per Review Organization")