
***

## Federated Authentication and Authorization Infrastructure (FAAID)

The AAI services manage secured credentials, allowing through APIs to issue, verify, revoke verifiable credentials in the W3C standard. Since authentication and authorization takes place through the selective detection of user attributes (i.e., W3C verifiable credentials3, a service is therefore necessary that allows the issuance, revocation and verification

## Prerequisites and Installation Environment

The AAI service is available in the form of a Docker image, can be deployed in any environment (local, cloud) and in any operating systems (Windows, Mac OS, Linux), if Docker and docker- compose plugin are installed. The Docker image is available on project’s Harbor, which is container registry at the following URL: https://harbor.gftinnovation.eu/fame/fame-aai-identity-ssi-agent.
In addition to Docker Compose deployment scripts, Kubernetes deployment capabilities are also supported, enabling seamless automation of continuous integration and deployment through tools like Harbor [Harbor], Argo CD [Argo-CD], and GitLab CI [GITLAB]. Kubernetes orchestrates containerized applications, offering advanced features such as automated scaling, self-healing, and efficient management across diverse environments. By integrating Argo CD into the Kubernetes workflow, deployments are managed declaratively, ensuring consistency and reliability throughout development, and production stages. This approach not only accelerates the release cycle but also enhances rollback functionality, monitoring, and security. Kubernetes configuration is available on the following URL under AAI folder https://gitlab.gftinnovation.eu/fame/fame-integration.git.

## Installation Guide

To deploy aai-identity-ssi service in any environment, you can utilize the provided docker-
compose.yaml file.

Clone the repository:
```bash
git clone git@gitlab.gftinnovation.eu:fame/framework/aai.git
cd aai
```

Install dependencies:
```bash
# For Node.js
npm install
npm run start:dev
```

#### Docker

Ensure the following prerequisites are met before proceeding:
• The required file (e.g, docker-compose.yml) is available in the working directory.
• Both Docker and Docker Compose are installed on your system.

Make sure to have a default Docker installation

To build and run the Docker containers, execute the following commands from within the respective directory:
To change the configuration, update the .env file

#### Build the image and run the container

```bash
docker compose build # This builds the Docker images or
docker-compose -f docker/compose/build/docker-compose.yml build
docker compose up -d # This starts the Docker containers, this will require the .env & config files to be installed
or if want to build from docker
docker build -f  docker/compose/build/docker-compose.yml up -d .
```

The building process may take a few minutes. Once you execute the docker compose up command, three services will start:
oid4vc-fame-ssi-agent, oid4vci-fame-frontend.

- make sure you do unmount the config & env files before running the install-configs.sh again

```shell
docker compose down
```

#### Credential Offer API
POST https://identity.fame-horizon.eu/webapp/credential-offers

 #### Description
This API allows clients to request credential offers based on a pre-authorized OAuth2 code flow. Additional user metadata can be supplied to assist in credential generation.

 #### Request Body
 ```bash
{
  "credentials": [
    "FAMEv1"
  ],
  "grants": {
    "urn:ietf:params:oauth:grant-type:pre-authorized_code": {
      "pre-authorized_code": "bs9mFfTAnJ3629R1wmMRLA",
      "user_pin_required": false
    }
  },
  "credentialDataSupplierInput": {
    "uid": "fame_70n3e8g7w",
    "affiliation": "fame",
    "region": "Germany",
    "role": "user",
    "nickname": "Jhon"
  }
}
```

#### Example curl Request

```bash
curl -X POST https://identity.fame-horizon.eu/webapp/credential-offers \
  -H "Content-Type: application/json" \
  -d '{
        "credentials": ["FAMEv1"],
        "grants": {
          "urn:ietf:params:oauth:grant-type:pre-authorized_code": {
            "pre-authorized_code": "bs9mFfTAnJ3629R1wmMRLA",
            "user_pin_required": false
          }
        },
        "credentialDataSupplierInput": {
          "uid": "fame_70n3e8g7w",
          "affiliation": "fame",
          "region": "Germany",
          "role": "user",
          "nickname": "Jhon"
        }
      }'
  ```

#### Fields Details 

credentials (array of strings) — Required
List of credential types to be issued.

Example: ["FAMEv1"]

grants (object) — Required
OAuth2 pre-authorized code grant details:

pre-authorized_code (string): Received from the authorization server

user_pin_required (boolean): If the user must provide a PIN

credentialDataSupplierInput (object) — Optional
Metadata for credential issuance:

uid (string): Unique user identifier

affiliation (string): Organization or group

region (string): Region info (e.g. country)

role (string): User role (e.g. "user")

nickname (string): Preferred user nickname

### credential-offer-status

```bash
POST https://auth.fame-horizon.eu/credential-offer-status

```
This API checks the status of a credential offer based on the provided credential offer ID.

### Request example 

```bash
POST https://auth.fame-horizon.eu/credential-offer-status
Content-Type: application/json

{
  "id": "kdrkAdKEDLuMCuh8gy3qmm"
}
```

---

## API Documentation
| Method | Endpoint | Description |
|--------|----------|-------------|
| POST   | //credential-offers | Issues credentials to the user |
| POST| https://auth.fame-horizon.eu/credential-offer-status| Checks credentials’ status|
|GET|https://auth.fame-horizon.eu/definitions/FAMEv1/auth-requests|Verifies user credentials when logging into the marketplace|
|GET|https://identity.fame-horizon.eu/openid-credential-issuer|OpenId API link for issuers|
|GET|https://identity.fame-horizon.eu/well-known/openid-configuration|OpenId API link for configurations|
|GET|https://identity.fame-horizon.eu/token|Gets the token|
|POST|https://identity.fame-horizon.eu/credentials|Performs credentials’ communications with wallet|

---

---

## **Table of Contents**
1. [Overview](#overview)
2. [Base URLs](#base-urls)
3. [Authentication](#authentication)
4. [Endpoints](#endpoints)
5. [Response Codes](#response-codes)
6. [Example Usage](#example-usage)
7. [Changelog](#changelog)
8. [Contact](#contact)

---

## **Overview**
The Credential API enables:
- Issuing credentials to users
- Checking credential status
- Verifying user credentials
- Managing OpenID configurations
- Secure token generation and wallet communications

---

## **Base URLs**
- **Auth Service**: `https://auth.fame-horizon.eu`
- **Identity Service**: `https://identity.fame-horizon.eu`

---

## **Authentication**
All endpoints require a valid **Bearer Token** for authorization.

**To authenticate:**
1. Obtain a token from the `/token` endpoint.
2. Include the token in the `Authorization` header for every request:

```
Authorization: Bearer <your-token>
```

---

## **Endpoints**

### 1. Issue Credentials
**POST** `//credential-offers`  
Issues credentials to the user.

#### Request Example:
```bash
curl -X POST //credential-offers \
-H "Content-Type: application/json" \
-H "Authorization: Bearer <your-token>" \
-d '{ "user_id": "12345" }'
```

#### Response Example:
```json
{
  "status": "success",
  "message": "Credential issued successfully"
}
```

---

### 2. Check Credential Status
**POST** `https://auth.fame-horizon.eu/credential-offer-status`  
Checks the status of issued credentials.

#### Request Example:
```bash
curl -X POST https://auth.fame-horizon.eu/credential-offer-status \
-H "Content-Type: application/json" \
-H "Authorization: Bearer <your-token>" \
-d '{ "credential_id": "abc123" }'
```

#### Response Example:
```json
{
  "status": "pending",
  "message": "Credential verification in progress"
}
```

---

### 3. Verify User Credentials
**GET** `https://auth.fame-horizon.eu/definitions/FAMEv1/auth-requests`  
Verifies user credentials when logging into the marketplace.

---

### 4. OpenID Credential Issuer
**GET** `https://identity.fame-horizon.eu/openid-credential-issuer`  
Provides the OpenID API link for credential issuers.

---

### 5. OpenID Configuration
**GET** `https://identity.fame-horizon.eu/well-known/openid-configuration`  
Returns OpenID configuration details.

---

### 6. Get Token
**GET** `https://identity.fame-horizon.eu/token`  
Retrieves an authentication token required for secured endpoints.

---

### 7. Credential Communication with Wallet
**POST** `https://identity.fame-horizon.eu/credentials`  
Handles credential exchange and communication with the wallet.

---

## **Response Codes**
| Code | Description                     |
|------|---------------------------------|
| 200  | OK – Successful request        |
| 400  | Bad Request – Invalid input    |
| 401  | Unauthorized – Missing token   |
| 500  | Internal Server Error          |

---

## **Example Usage**
Here’s how to issue a credential using **cURL**:

```bash
curl -X POST https://auth.fame-horizon.eu/credential-offers \
-H "Authorization: Bearer <your-token>" \
-H "Content-Type: application/json" \
-d '{
  "user_id": "12345",
  "credential_type": "basic"
}'
```

---

## **Changelog**
- **v1.0.0** – Initial release with credential issuance, status check, and OpenID integration.

---

## **Contact**
For support or questions, please contact us at:  
📧 **support@fame-horizon.eu**
