const fs = require('fs');

// Funzione per caricare le variabili d'ambiente da un file
function loadEnvVariables() {
  const envFile = '.env';
  if (fs.existsSync(envFile)) {
    const envConfig = fs.readFileSync(envFile, 'utf8');
    const lines = envConfig.split('\n');
    lines.forEach(line => {
      const [key, value] = line.split('=');
      process.env[key.trim()] = value?.trim();
    });
  }
}

// Funzione per impostare le variabili d'ambiente per l'applicazione React
function setReactAppEnvVariables() {
  process.env.REACT_APP_ACCOUNT_INGRESS_CONTRACT_ADDRESS = process.env.ACCOUNT_INGRESS_CONTRACT_ADDRESS;
  process.env.REACT_APP_NODE_INGRESS_CONTRACT_ADDRESS = process.env.NODE_INGRESS_CONTRACT_ADDRESS;
  process.env.REACT_APP_CHAIN_ID = process.env.CHAIN_ID;
}

// Carica le variabili d'ambiente
loadEnvVariables();

// Imposta le variabili d'ambiente per l'applicazione React
setReactAppEnvVariables();

// Esegui altre operazioni come necessario
// Ad esempio, avvia il server React, ecc.
