import { HttpModule } from '@nestjs/axios';
import { Module } from '@nestjs/common';
import { ConfigModule } from '@nestjs/config';
import { MongooseModule } from '@nestjs/mongoose';
import { TypeOrmModule } from '@nestjs/typeorm';
import * as process from 'node:process';
import { MemberEntity, AuthorityEntity, AccountEntity, TransactionEntity } from './membership/membership-entities';
import { UserEntity } from './oa/user-entity';
import { MembershipModule } from './membership/membership-module';
import { RequestsModule } from './requests/requests-module';
import { OAModule } from './oa/oa-module';
import { StatsModule } from './stats/stats-module';
import { BlacklistUserEntity, BlacklistMemberEntity, BlacklistAuthorityEntity } from './membership/blacklist-entities';


@Module({
  imports: [
    ConfigModule.forRoot({
      envFilePath: '.env',
      isGlobal: true,
    }),
    TypeOrmModule.forRoot({
      type: 'mysql',
      host: process.env.MYSQL_HOST,
      port: parseInt(process.env.MYSQL_PORT) || 3306,
      username: process.env.MYSQL_USER,
      password: process.env.MYSQL_PASSWORD,
      database: process.env.MYSQL_DATABASE,
      entities: [MemberEntity, AuthorityEntity, AccountEntity, TransactionEntity, UserEntity, BlacklistUserEntity, BlacklistMemberEntity, BlacklistAuthorityEntity],
      synchronize: true,
    }),
    MongooseModule.forRoot(process.env.MONGO_URI, {
      dbName: process.env.MONGO_NAME,
      authSource: process.env.MONGO_AUTH_SOURCE,
    }),
    HttpModule,
    MembershipModule,
    RequestsModule,
    StatsModule,
    OAModule,
  ],

  controllers: [],
  providers: [],
})
export class AppModule {
}
