// these are the maximum lenghts of the fields in DTOs that may contain user-provided input
export const ID_MAXL = 60; // generic, permissive rule for system-generated IDs
export const OTP_MAXL = 5;
export const SHORTID_MAXL = 22;
export const HALF_LINER_MAXL = 40;
export const ONE_LINER_MAXL = 80;
export const TWO_LINER_MAXL = 160;
export const TEXTCOL_MAXL = 255;
export const TXT_SHORT_MAXL = 500;
export const HTTP_ERR_400: string = 'Bad Request: missing or invalid input data';
export const HTTP_ERR_401: string = 'Unauthorized: missing or invalid authentication';
export const HTTP_ERR_403: string = 'Forbidden: access denied due to policy';
export const HTTP_ERR_404: string = 'Not Found: the target resource does not exist or is in invalid state';
export const HTTP_ERR_500: string = 'Internal Server Error: something went wrong, the operation failed';
export const HTTP_ERR_502: string = 'Bad Gateway: an upstream server was unable to process this request';
export const ROA_PID = '0000000000000000000000'; // the PID of the ROA (Root Onboarding Authority) 

export enum OrganizationType {
    FPO = "FPO", // for-profit private or public/private organization
    NPO = "NPO", // not-for-profit private or public/private organization
    RES = "RES", // research institution
    EDU = "EDU", // educational / academic institution
    LEO = "LEO", // law enforcement organization
    PUB = "PUB", // public administration body or agency
    UKN = "UKN", // unknown or unspecified
}

export enum EntityStatus {
    ACTIVE = "ACTIVE", 
    INACTIVE = "INACTIVE", // Revertable status, when supported; when not, it's equivalent to TERMINATED)
    TERMINATED = "TERMINATED", // Permanent status, when status reversal is supported: when not, it's synonymous to INACTIVE)
}

export enum AccountStatus {
    ACTIVE = "ACTIVE", 
    INACTIVE = "INACTIVE"
}

export enum UserRole {
    ADM = "admin",
    OPR = "operator",
    USR = "user",
}

export enum UserStatus {
    INVITED = "INVITED",
    ONBOARDED = "ONBOARDED",
    OFFBOARDED = "OFFBOARDED",
}

export enum ListOperation {
    ADD = "ADD",
    REMOVE = "REMOVE",
}
