import { ApiProperty } from "@nestjs/swagger";
import { AccountStatus } from 'src/constants';

export class AccountBalance {

    @ApiProperty({
        description: 'Amount of FDE tokens (positive number with 2 fixed decimal places)',
    })
    balance: string;

    @ApiProperty({
        description: `Status of trading account (accepted values: [${Object.values(AccountStatus).join(', ')}])`
    })
    status: AccountStatus;
}