import { IsAlphanumeric, IsEnum, IsOptional, IsString, Length } from 'class-validator';
import { EntityStatus, SHORTID_MAXL, TEXTCOL_MAXL } from '../constants';
import { ApiPropertyOptional } from '@nestjs/swagger';
import { PaginationParams } from './pagination-params';

export class AccountFilter extends PaginationParams {
    
    @ApiPropertyOptional({
        description: `Filter by UID of owning user (OPTIONAL)`,
    })
    @IsOptional()
    @IsString()
    @Length(1, TEXTCOL_MAXL)
    usr?: string;

    @ApiPropertyOptional({
        description: `Filter by PID of owning member (OPTIONAL, 22-characters short UUID)`,
        example: 'w5xQXA2f22UEzLGf9z9Zio',
    })
    @IsOptional()
    @IsAlphanumeric()
    @Length(SHORTID_MAXL, SHORTID_MAXL)
    own?: string;

    @ApiPropertyOptional({
        description: `Filter by PID of onboarding authority of the owning user (OPTIONAL, 22-characters short UUID)`,
        example: 'w5xQXA2f22UEzLGf9z9Zio',
    })
    @IsOptional()
    @IsAlphanumeric()
    @Length(SHORTID_MAXL, SHORTID_MAXL)
    aut?: string;

    @ApiPropertyOptional({
        description: `Filter by account status (OPTIONAL, accepted values: [${Object.values(EntityStatus).join(', ')}])`,
    })
    @IsOptional()
    @IsEnum(EntityStatus)
    sta?: EntityStatus;
}
