import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';

export class Account {

    @ApiProperty({
        description: 'Address of the Ethereum account',
    })
    tid: string;

    @ApiProperty({
        description: 'UID of owning user',
    })
    owningUser: string;

    @ApiPropertyOptional({
        description: 'PID of owning member (user affiliation), if applicable',
    })
    owningMember?: string;

    @ApiProperty({
        description: 'PID of onboarding authority of the owning user',
    })
    userAuthority: string;
    
    @ApiProperty({
        description: 'Date of enrolmment (ISO8601)',
    })
    enrolled: string;

    @ApiPropertyOptional({
        description: 'Date of disenrolment, if applicable (ISO8601)',
    })
    disenrolled?: string;
}