import { ApiProperty } from "@nestjs/swagger";
import { IsDecimal, IsNotEmpty } from 'class-validator';

export class Amount {

    @ApiProperty({
        description: 'Amount of FDE tokens (REQUIRED)',
    })
    @IsNotEmpty()
    @IsDecimal({ decimal_digits: '2,2', force_decimal: true })
    amount: string;
}