import { IsAlphanumeric, IsEnum, IsOptional, Length } from 'class-validator';
import { EntityStatus, SHORTID_MAXL } from '../constants';
import { ApiPropertyOptional } from '@nestjs/swagger';
import { PaginationParams } from './pagination-params';

export class AuthorityFilter extends PaginationParams {
    
    @ApiPropertyOptional({
        description: `Owner PID (OPTIONAL, 22-characters short UUID)`,
        example: 'w5xQXA2f22UEzLGf9z9Zio',
    })
    @IsOptional()
    @IsAlphanumeric()
    @Length(SHORTID_MAXL, SHORTID_MAXL)
    own?: string;

    @ApiPropertyOptional({
        description: `Authority status (OPTIONAL, accepted values: [${Object.values(EntityStatus).join(', ')}])`,
    })
    @IsOptional()
    @IsEnum(EntityStatus)
    sta?: EntityStatus;
}
