import {ApiProperty, ApiPropertyOptional} from "@nestjs/swagger";

export class Authority {

    @ApiProperty({
        description: 'Authority DID',
    })
    did: string;

    @ApiProperty({
        description: 'Member PID',
    })
    pid: string;

    @ApiProperty({
        description: 'Member name (legal entity)',
    })
    name: string;

    @ApiProperty({
        description: 'Activated date (ISO 8601 format)',
    })
    activated: string;

    @ApiPropertyOptional({
        description: 'Deactivated date (ISO 8601 format, empty if authority is active)',
    })
    deactivated?: string;

    @ApiProperty({
        description: 'True if authority is active, false otherwise',
    })
    active: boolean;
}
