import { ApiProperty } from '@nestjs/swagger';
import { IsAlphanumeric, IsNotEmpty, IsNumberString, IsString, Length } from 'class-validator';
import { OTP_MAXL, SHORTID_MAXL } from '../constants';

export class CredentialClaim {

    @ApiProperty({
        description: 'Invitation ID (22-characters short UUID)',
        example: 'w5xQXA2f22UEzLGf9z9Zio',
    })
    @IsNotEmpty()
    @IsAlphanumeric()
    @Length(SHORTID_MAXL, SHORTID_MAXL)
    iid: string;

    @ApiProperty({
        description: 'One-time password (5-characters numeric string)',
        example: '12345',
    })
    @IsNotEmpty()
    @IsNumberString()
    @Length(OTP_MAXL, OTP_MAXL)
    otp: string;
}
