import { IsEnum, IsISO31661Alpha2, IsOptional, IsString, Length, Matches } from 'class-validator';
import { OrganizationType, EntityStatus, TWO_LINER_MAXL } from '../constants';
import { ApiPropertyOptional } from '@nestjs/swagger';
import { PaginationParams } from './pagination-params';

export class MemberFilter extends PaginationParams {
    
    @ApiPropertyOptional({
        description: 'Filter by legal name (OPTIONAL, partial match, case insensitive)',
    })
    @IsOptional()
    @IsString()
    @Length(1, TWO_LINER_MAXL)
    @Matches(/^[\p{Script=Latin}\p{N}\p{P}\p{Z}]+$/u, {
        message: 'Legal name must only include Latin letters, numbers, punctuation, and spaces (no newlines).'
    })
    nam?: string;

    @ApiPropertyOptional({
        description: `Filter by organization type (OPTIONAL, accepted values: [${Object.values(OrganizationType).join(', ')}])`,
    })
    @IsOptional()
    @IsEnum(OrganizationType)
    typ?: OrganizationType;

    @ApiPropertyOptional({
        description: 'Filter by country of residence (OPTIONAL, ISO 3166-1 alpha-2 code)',
    })
    @IsOptional()
    @IsISO31661Alpha2()
    cnt?: string;

    @ApiPropertyOptional({
        description: `Filter by member status (OPTIONAL, accepted values: [${Object.values(EntityStatus).join(', ')}])`,
    })
    @IsOptional()
    @IsEnum(EntityStatus)
    sta?: EntityStatus;
}
