import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';
import { IsEnum, IsNotEmpty, IsOptional, IsString, Length, ValidateNested } from 'class-validator';
import { Type } from 'class-transformer';
import { OrganizationType, ROA_PID, TEXTCOL_MAXL } from '../constants';
import { ContactInfo } from './contact-info';
import { LegalEntity } from './legal-entity';

export class MemberOnboardingRequest {

    @ApiProperty({
        description: 'Legal entity information (REQUIRED)',
    })
    @IsNotEmpty()
    @ValidateNested()
    @Type(() => LegalEntity)
    org: LegalEntity;

    @ApiProperty({
        description: `Organization type (REQUIRED, accepted values: [${Object.values(OrganizationType).join(', ')}])`,
        enum: OrganizationType,
    })
    @IsNotEmpty()
    @IsEnum(OrganizationType)
    type: OrganizationType;

    @ApiPropertyOptional({
        description: 'Contact info of member representative (OPTIONAL)',
    })
    @IsOptional()
    @ValidateNested()
    @Type(() => ContactInfo)
    rep?: ContactInfo;

    @ApiProperty({
        description: 'PID of delegate OA or DID of own OA (REQUIRED, use "' + ROA_PID + '" for ROA delegation)',
    })
    @IsNotEmpty()
    @IsString()
    @Length(1, TEXTCOL_MAXL)
    oa: string;
}
