import {ApiProperty} from "@nestjs/swagger";
import { OrganizationType } from '../constants';

export class MemberRef {

    @ApiProperty({
        description: 'PID of member (unique identifier)',
    })
    pid: string;

    @ApiProperty({
        description: 'Legal entity name',
    })
    name: string;

    @ApiProperty({
        description: 'Type of organization',
        enum: OrganizationType,
    })
    type: OrganizationType;

    @ApiProperty({
        description: 'Country of residence',
    })
    country: string;

    @ApiProperty({
        description: 'True if member has ONBOARDED status, false otherwise',
    })
    active: boolean;
}
