import { ApiPropertyOptional } from '@nestjs/swagger';
import { IsEnum, IsOptional, IsString, Length, ValidateIf, ValidateNested } from 'class-validator';
import { Type } from 'class-transformer';
import { OrganizationType, ROA_PID, TEXTCOL_MAXL } from '../constants';
import { ContactInfo } from './contact-info';

export class MemberUpdateRequest {

    @ApiPropertyOptional({
        description: `Organization type (OPTIONAL for update request, but REQUIRED in database - cannot be set to null, accepted values: [${Object.values(OrganizationType).join(', ')}])`,
        enum: OrganizationType,
    })
    @IsOptional()
    @IsEnum(OrganizationType)
    type?: OrganizationType;

    @ApiPropertyOptional({
        description: 'Contact info of member representative (OPTIONAL, set to null to clear)',
        type: ContactInfo,
        nullable: true,
    })
    @IsOptional()
    @ValidateIf(o => o.rep !== null)
    @ValidateNested()
    @Type(() => ContactInfo)
    rep?: ContactInfo | null;

    @ApiPropertyOptional({
        description: 'PID of delegate OA or DID of own OA (OPTIONAL for update request, but REQUIRED in database - cannot be set to null, use "' + ROA_PID + '" for ROA delegation)',
    })
    @IsOptional()
    @IsString()
    @Length(1, TEXTCOL_MAXL)
    oa?: string;
}
