import {ApiProperty, ApiPropertyOptional} from '@nestjs/swagger';
import { OrganizationType } from '../constants';
import { ContactInfo } from './contact-info';
import { LegalEntity } from './legal-entity';

export class Member {

    @ApiProperty({
        description: 'PID of member (unique identifier)',
    })
    pid: string;

    @ApiProperty({
        description: 'Legal entity information',
    })
    org: LegalEntity;

    @ApiProperty({
        description: 'Type of organization',
        enum: OrganizationType,
    })
    type: OrganizationType;

    @ApiPropertyOptional({
        description: 'Contact info of member representative, if present',
    })
    rep?: ContactInfo;

    @ApiProperty({
        description: 'Onboarding Authority: either a PID or the "SELF" keyword',
    })
    authority: string;

    @ApiProperty({
        description: 'Date of onboarding (ISO8601)',
    })
    onboarded: string;

    @ApiPropertyOptional({
        description: 'Data of offboarding, if applicable (ISO8601)',
    })
    offboarded?: string;
}
