import { AuthorityEntity, MemberEntity } from 'src/membership/membership-entities';

/**
 * Context object containing pre-resolved data for OA changes.
 * This avoids redundant database queries in the storage layer.
 */
export class OAChangeContext {
    /** Current authority entity (only for SCENARIO 2 where member has self-OA) */
    currentAuthority?: AuthorityEntity;

    /** Resolved delegate member entity (for SCENARIO 1A and 2A) */
    delegateMember?: MemberEntity;

    /** Resolved delegate authority entity (for SCENARIO 2A) */
    delegateAuthority?: AuthorityEntity;

    /** Whether the new OA is a DID (self-OA) or PID (delegated OA) */
    newOAIsSelf: boolean;

    /** Whether the member currently has self-OA (SCENARIO 2) or delegates (SCENARIO 1) */
    currentOAIsSelf: boolean;
}
