import { ApiPropertyOptional } from '@nestjs/swagger';
import { IsOptional, IsInt, Min, Max } from 'class-validator';
import { Type } from 'class-transformer';

/**
 * Base class for pagination parameters.
 * All filter DTOs that support pagination should extend this class.
 */
export class PaginationParams {

    @ApiPropertyOptional({
        description: 'Maximum number of results to return (OPTIONAL, default: no limit)',
        type: Number,
        minimum: 1,
        maximum: 1000,
    })
    @IsOptional()
    @Type(() => Number)
    @IsInt()
    @Min(1)
    @Max(1000)
    l?: number; // limit

    @ApiPropertyOptional({
        description: 'Offset of the first result to return (OPTIONAL, default: 0)',
        type: Number,
        minimum: 0,
    })
    @IsOptional()
    @Type(() => Number)
    @IsInt()
    @Min(0)
    o?: number; // offset
}
