import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';
import { IsString, Length, IsOptional } from 'class-validator';
import { TEXTCOL_MAXL } from '../constants';

export class SecurityContext {

    @ApiProperty({
        description: 'DID of Onboarding Authority (REQUIRED)',
    })
    @IsString()
    @Length(1, TEXTCOL_MAXL)
    did: string;

    @ApiPropertyOptional({
        description: 'PID of affiliation (OPTIONAL)',
    })
    @IsOptional()
    @IsString()
    @Length(1, TEXTCOL_MAXL)
    pid?: string;

    @ApiPropertyOptional({
        description: 'UID of user (OPTIONAL)',
    })
    @IsOptional()
    @IsString()
    @Length(1, TEXTCOL_MAXL)
    uid?: string;
}